/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#ifndef  __LibEnv__
#define  __LibEnv__

#include "sysopenv.h"

#ifdef SYSWin32
#include <string.h>
#include <ctype.h>

/***** constants **************************************************************/
// return values
#define rtErr   0x01
#define rtWrn   0x02
#define rtOk    0x00

/***** makros *****************************************************************/

#define TSTRING tString
#define PSTRING pString

#define STRInit(aString, aPChar) \
            StrInit(&aString, aPChar)

#define STRDone(aString) \
            StrDone(&aString)

#define STRAssign(aDestString, aSrcString) \
        StrAssign(&aDestString, &aSrcString)

#define STRChAssign(aDestString, aPChar) \
        StrChAssign(&aDestString, aPChar)

#define STRMove(aDestString, aSrcString) \
          STRInit(aDestString, "");            \
          STRAssign(aDestString, aSrcString);
/*
    aDestString.mSize = aSrcString.mSize;   \
    aDestString.mLength = aSrcString.mLength; \
    aDestString.mString = aSrcString.mString; \
    StrInit(&aSrcString, NULL);
*/
#define STRLen(aString) \
         (aString).mLength
// Converts lower characters to upper characters
#define STRUpCase(aString) \
       (aString).mString = strupr((aString).mString);
// STRPChar() can be indexed between 0 <= i < STRLen()
// single chars can be read or replaced
#define STRPChar(aString) \
            (aString).mString

#define STRCompare(aString1, aString2) \
    strcmp(aString1.mString, aString2.mString)
#define STRChCompare(aString, apChar) \
    strcmp(aString.mString, apChar)

// for function variables: See STRCompare
#define FSTRCompare strcmp

#define STRCompareNoCase(aString1, aString2) \
    stricmp(aString1.mString, aString2.mString)
#define STRChCompareNoCase(aString, apChar) \
    stricmp(aString.mString, apChar)

#define STREqualNoCase(aString1, aString2) \
    (stricmp(aString1.mString, aString2.mString) == 0)
#define STRChEqualNoCase(aString, apChar) \
    (stricmp(aString.mString, apChar) == 0)

#define STRAddChar(aString, aChar) \
     StrAddChar(&aString, aChar)

#define STRConcat(aDestString, aSrcString) \
    StrConcat(&aDestString, &aSrcString)

#define STRChConcat(aDestString, aSrcString) \
    StrChConcat(&aDestString, aSrcString)

#define STRPChConcat(aDestString, aSrcString) \
    StrChConcat(aDestString, aSrcString)

#define STRToInt(aString) \
        atoi(aString.mString)

#define STRToReal(aString) \
        atof(aString.mString)

#define STRRemoveLastChar(aString) \
        { \
            if (aString.mLength > 0) \
            { \
                aString.mLength = aString.mLength - 1; \
                strncpy(aString.mString, aString.mString, aString.mLength); \
            } \
        }

// Macros for Char * converting
#define PCHARToInt(apChar) \
         atoi(apChar)
#define PCHARLength(apChar) \
         strlen(apChar)
#define CHARIsAlpha(c)  \
    isalpha(c)

#define CHARIsDigit(c)  \
    isdigit(c)

#define CHARIsAlnum(c)  \
    isalnum(c)

#define STRIntConcat(aString, aInteger) \
        StrIntConcat(&aString, aInteger)

#define STRChCreate \
        sprintf

/***** typ definitions ********************************************************/

typedef unsigned char tByte;
typedef tByte *pByte;

typedef struct _tString
{
    int    mSize;    // size of allocated memory
    int    mLength;  // current length of the string
    char * mString;  // the string
} tString, * pString;

/***** function prototypes ****************************************************/
// string functions
void StrInit(pString aString, char * aPchar);
void StrDone(pString aString);
void StrAssign(pString aDestString, pString aSrcString);
void StrChAssign(pString aDestString, char *aSrcString);
void StrConcat(pString aDestString, pString aSrcString);
void StrChConcat(pString aDestString, char *aSrcString);
void StrIntConcat(pString apString, int aInteger);
void StrAddChar(pString aString, char aChar);

#endif
/***** end SYSWin32 ***********************************************************/

/***** LINUX ******************************************************************/
#ifdef SYSLinux

#endif
/***** end SYSLinux ***********************************************************/

#endif
