/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#include "sysopenv.h"
#include "libenv.h"

/***** string functions *******************************************************/

/* -------------------------------------------------------------------------- */
char * StrAlloc(pString aString, int aSize)
{
    aString->mSize = aSize;
    return (aString->mString = (char *) GETMem(aSize));
}

/* -------------------------------------------------------------------------- */
void StrInit(pString aString, char * aPchar)
{
    static char EmptyString[] = "";
    int len;
    if (aPchar && *aPchar)
    {
        len = strlen(aPchar);
        strcpy(StrAlloc(aString, len+1), aPchar);
        aString->mLength = len;
    }
    else
    {
        aString->mLength = 0;
        aString->mSize = 0;
        aString->mString = EmptyString;
    }
}

/* -------------------------------------------------------------------------- */
void StrDone(pString aString)
{
    if (aString->mSize)
    {
        FREEMem(aString->mString, aString->mSize);
        aString->mSize = 0;
    }
}

/* -------------------------------------------------------------------------- */
void StrAssign(pString aDestString, pString aSrcString)
{
    if (aDestString->mSize < aSrcString->mSize)
    {
        StrDone(aDestString);
        StrAlloc(aDestString, aSrcString->mLength + 1);
    }
    strcpy(aDestString->mString, aSrcString->mString);
    aDestString->mLength = aSrcString->mLength;
}

/* -------------------------------------------------------------------------- */
void StrChAssign(pString aDestString, char *aSrcString)
{
    TSTRING aString;
    STRInit(aString, aSrcString);
    StrAssign(aDestString, &aString);
    StrDone(&aString);
}

/* -------------------------------------------------------------------------*/
void StrConcat(pString aDestString, pString aSrcString)
{
    int vSize = aDestString->mLength + aSrcString->mLength + 1;
    char *vTmpString = (char *) GETMem(vSize);

    strcpy(vTmpString, aDestString->mString);
    strcat(vTmpString, aSrcString->mString);

    StrDone(aDestString);
    StrInit(aDestString, vTmpString);
    FREEMem(vTmpString, vSize);
}

/* -------------------------------------------------------------------------*/
void StrChConcat(pString aDestString, char *aSrcString)
{
    TSTRING aString;
    STRInit(aString, aSrcString);
    StrConcat(aDestString, &aString);
  StrDone(&aString);
}

/* -------------------------------------------------------------------------*/
void StrIntConcat(pString apString, int aInteger)
{
    char *vTmpString = (char *) GETMem(8);
    TSTRING aString;

    sprintf(vTmpString, "%d", aInteger);
    STRInit(aString, vTmpString);
    StrConcat(apString, &aString);

    FREEMem(vTmpString, 8);
}

/* -------------------------------------------------------------------------- */
void StrAddChar(pString aString, char aChar)
{
    if (aString->mSize == 0)
    {
        StrAlloc(aString, 128);
        aString->mLength = 1;
    }
    else
    {
        aString->mLength++;
        if (aString->mLength >= aString->mSize)
        {
            char * vOldMString;
            int vNewMSize;
//#if      FREEMemUsesSize != 0
            int vOldMSize;
//#endif
            vOldMString = aString->mString;
//#if      FREEMemUsesSize != 0
            vOldMSize =
//#endif
            vNewMSize = aString->mSize;
            if (vNewMSize < 0xC0)
                vNewMSize = 0x100;
            else if (vNewMSize < 0x1000)
        //      vNewMSize <<= 1;
            vNewMSize = 0x1000;
            else vNewMSize += 0x1000;
            StrAlloc(aString, vNewMSize);
            strcpy(aString->mString, vOldMString);
//#if      FREEMemUsesSize != 0
            FREEMem(vOldMString, vOldMSize);
//#endif

        }
    }
    aString->mString[aString->mLength-1] = aChar;
    aString->mString[aString->mLength] = '\0';
}




