/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#ifndef __SysOpEnv__
#define __SysOpEnv__

/***** WIN32 ******************************************************************/
#ifdef SYSWin32

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
/***** memory allocation ******************************************************/
#define GETMem(aSize) \
    malloc(aSize)
#define FILLChar(aPtr,aChar,aSize)     \
   memset(aPtr,aChar,aSize)
#define FREEMemUsesSize 0
// Copy Memory from S to D:  D = Dest. S= Source, C= Count
#define COPYMemDSC(aDest, aSrc, aLength)     \
   memmove(aDest, aSrc, aLength)
#define FREEMem(aPtr, aSize) \
    free(aPtr)

/***** file handling **********************************************************/
#define TFILECommand     FILE*
#define TFILEBsdl        FILE*
#define TFILE1532Data    FILE*

#define OPENCommandFile(aFile, aFileName) \
        (aFile) = fopen(aFileName, "rb")

#define OPENBsdlFile(aFile, aFileName) \
        (aFile) = fopen(aFileName, "rb")

#define OPEN1532DataFileRO(aFile, aFileName) \
        (aFile) = fopen(aFileName, "rb")

#define OPEN1532DataFileRW(aFile, aFileName) \
        (aFile) = fopen(aFileName, "a+")

#define OPENFileW(aFile, aFileName) \
        (aFile) = fopen(aFileName, "w")

#define CLOSECommandFile(aFile) \
        fclose(aFile)

#define CLOSEBsdlFile(aFile) \
        fclose(aFile)

#define CLOSE1532DataFile(aFile) \
        fclose(aFile)

#define CLOSEFile(aFile) \
        fclose(aFile)

#define READCharCommandFile(c, mDataFile, vEof) \
        c = ReadChar(mDataFile, &vEof);

#define READCharBsdlFile(c, mDataFile, vEof) \
        c = ReadChar(mDataFile, &vEof);

#define READChar1532DataFile(c, mDataFile, vEof) \
        c = ReadChar(mDataFile, &vEof);

#define UNREADCharCommandFile(aChar, aFile) \
        ungetc(aChar, aFile)

#define UNREADCharBsdlFile(aChar, aFile) \
        ungetc(aChar, aFile)

#define UNREADChar1532DataFile(aChar, aFile) \
        ungetc(aChar, aFile)

#define WRITEChar1532DataFile(aChar, aFile) \
        (aChar) = fputc(aFile)

// file position
#define SETFilePos1532DataFile(aFile, aPos) \
        SetFilePos(aFile, aPos)

/***** screen functions *******************************************************/
#define WRITEToScreen printf
#define VWRITEToScreen vprintf

#define WRITEToFile fprintf
#define VWRITEToFile vfprintf

/************ Time handling    *************/
// System Time Counter in miliseconds
// Windows-Function
#define GETTickCount GetTickCount

#define TTIME time_t
#define GETTime time
#define TIMEDiff difftime
/***** function prototypes ****************************************************/
char ReadChar(FILE *aFile, int *aEof);
int SetFilePos(FILE *aFile, long aPos);

#endif
/***** end SYSWin32 ***********************************************************/


/***** LINUX ******************************************************************/
#ifdef SYSLinux

#endif
/***** end SYSLinux ***********************************************************/

#endif


