/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
// basjdrvio.h    Include file for Parallel Port JTAG Cable Driver
//
// $Header: \\\\Bscan_server\\cascon\\Dvlp\\Prj\\Prog1532\\Source\\basjdrvio.h,v 1.1 2000-10-12 07:49:17+02 paelicke Exp $
//
// Define the IOCTL codes we will use.  The IOCTL code contains a command
// identifier, plus other information about the device, the type of access
// with which the file must have been opened, and the type of buffering.
//
#ifndef BASJDRVIO_H
#define BASJDRVIO_H

// Device type           -- in the "User Defined" range."
#define JDRV_TYPE 40000

// The IOCTL function codes from 0x800 to 0xFFF are for customer use.

#define IOCTL_JDRV_READ_STATUS_PORT \
    CTL_CODE( JDRV_TYPE, 0x900, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_JDRV_READ_DATA_PORT \
    CTL_CODE( JDRV_TYPE, 0x901, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_JDRV_WRITE_DATA_PORT \
    CTL_CODE( JDRV_TYPE, 0x910, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_JDRV_BURST_DATA_PORT \
    CTL_CODE(JDRV_TYPE,  0x911, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_JDRV_BURSTBACK_DATA_PORT \
    CTL_CODE(JDRV_TYPE,  0x912, METHOD_BUFFERED, FILE_WRITE_ACCESS|FILE_READ_ACCESS)

//
//  Status values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-------------------------+-------------------------------+
//  |Sev|C|       Facility          |               Code            |
//  +---+-+-------------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
#define FACILITY_RPC_STUBS               0x3
#define FACILITY_RPC_RUNTIME             0x2
#define FACILITY_PARALLEL_ERROR_CODE     0x7
#define FACILITY_IO_ERROR_CODE           0x4


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: JDRV_INSUFFICIENT_RESOURCES
//
// MessageText:
//
//  Not enough memory was available to allocate internal storage needed for the device %1.
//
#define JDRV_INSUFFICIENT_RESOURCES       ((NTSTATUS)0xC0070003L)

//
// MessageId: JDRV_NO_SYMLINK_CREATED
//
// MessageText:
//
//  Unable to create the symbolic link for %1.
//
#define JDRV_NO_SYMLINK_CREATED           ((NTSTATUS)0x80070010L)

//
// MessageId: JDRV_NO_DEVICE_MAP_CREATED
//
// MessageText:
//
//  Unable to create the device map entry for %1.
//
#define JDRV_NO_DEVICE_MAP_CREATED        ((NTSTATUS)0x80070011L)

//
// MessageId: JDRV_CANT_FIND_PORT_DRIVER
//
// MessageText:
//
//  Unable to get device object pointer for port object.
//
#define JDRV_CANT_FIND_PORT_DRIVER        ((NTSTATUS)0xC0070015L)

#endif
