/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#include "bscandrv.h"
#include "basjdrvio.h" // Driver definitions
#include "sysopenv.h"
#include "logfkt.h"

void InitBurstInfo(pBurstInfo aInfo, long aSize)
{
 if (aInfo !=NULL) {
   FILLChar(aInfo,0,sizeof(tBurstInfo));
   aInfo->mImgSize = aSize;
   aInfo->mBufferEnd = aSize - tapBURSTEND;
   // Get the memory for buffers
   aInfo->mTdo = GETMem(aSize);
   aInfo->mTdi = GETMem(aSize);
   aInfo->mExpect = GETMem(aSize);
   // Init with zero for buffers
   if (aInfo->mTdo !=NULL) {
     FILLChar(aInfo->mTdo,0,aSize);
   };
   if (aInfo->mTdi != NULL) {
     FILLChar(aInfo->mTdi,0,aSize);
   };
   if (aInfo->mExpect != NULL )
     FILLChar(aInfo->mExpect,0,aSize);
 };
};
pBurstInfo NewBurstInfo(long aSize)
{pBurstInfo vBurstInfo;
  vBurstInfo = (pBurstInfo)GETMem(sizeof(tBurstInfo));
  if (vBurstInfo !=NULL) {
    InitBurstInfo(vBurstInfo,aSize);
  };
  return(vBurstInfo);
};
void FreeBurstInfo(pBurstInfo aInfo)
{  if (aInfo !=NULL) {
     DoneBurstInfo(aInfo);
     FREEMem(aInfo,sizeof(tBurstInfo));
   };
};
void DoneBurstInfo(pBurstInfo aInfo)
{long vSize = 0L;
   if (aInfo !=NULL) {
     vSize = aInfo->mImgSize;
     if (aInfo->mTdo != NULL)
       FREEMem(aInfo->mTdo,vSize);
     if (aInfo->mTdi != NULL)
       FREEMem(aInfo->mTdi,vSize);
     if (aInfo->mExpect != NULL)
       FREEMem(aInfo->mExpect,vSize);
     FreeDrvBuffer(aInfo);
   };
};
void InitDrvBuffer(pBurstInfo aInfo, long aSize)
{ long vOldSize = 0L;
  if ( aInfo !=NULL ) {
    vOldSize = aInfo->mDrvSize;
    if (aSize > vOldSize) {
    // Free the old buffers
    FreeDrvBuffer(aInfo);
    // Get the memeory of new buffer
    // -> Output
    aInfo->mDrvOutput = GETMem(aSize);
    FILLChar(aInfo->mDrvOutput,0,aSize);
    // -> Input
    aInfo->mDrvInput =  GETMem(aSize);
    FILLChar(aInfo->mDrvInput,0,aSize);
    // Set the corresponding new time
    aInfo->mDrvSize = aSize;
    };// greater buffer
  };// aInfo
};
void FreeDrvBuffer(pBurstInfo aInfo)
{ long vSize = 0L;
  if ( aInfo != NULL ) {
    vSize = aInfo->mDrvSize;
       if (aInfo->mDrvOutput != NULL)
        FREEMem(aInfo->mDrvOutput, vSize);
      if (aInfo->mDrvInput != NULL)
        FREEMem(aInfo->mDrvInput, vSize);
  };// aInfo
};

//***************************************************************
// JDRIVER FUNCTIONS
// Constructor of the driver
pJDriver JDriverNew()
{ pJDriver vDriver = (pJDriver) GETMem(sizeof(tJDriver));
  FILLChar(vDriver,0,sizeof(tJDriver));
  if (vDriver != NULL) {
    JDriverInit(vDriver);
  };
  return(vDriver);
};
void JDriverInit(pJDriver aDriver)
{  if (aDriver !=NULL) {
     aDriver->hWD = (HANDLE) NULL;
     aDriver->io_increment = 0;
     aDriver->jcab_base_port = (DWORD) -1;
//   aDriver->max_write_size = ( getenv("XDBGJTAGWRTRANSSIZE") == (char *) NULL ? 4096 : UT_STR::AToI( getenv("XDBGJTAGWRTRANSSIZE") ) );
     aDriver->max_write_size = ( getenv("XDBGJTAGWRTRANSSIZE") == (char *) NULL ? 4096 : atoi( getenv("XDBGJTAGWRTRANSSIZE") ) );
     aDriver->m_dwBufferSize = aDriver->max_write_size * 2;
     aDriver->m_transfer = (WD_TRANSFER *) NULL;




  }; // if aDriver
};
// Destructor of the Driver
void JDriverDone(pJDriver aDriver)
{ if (aDriver !=NULL) {
    aDriver->hWD = (HANDLE) NULL;
    aDriver->io_increment = 0;
    aDriver->jcab_base_port = (DWORD) -1;
    aDriver->m_dwBufferSize = 0;
    aDriver->max_write_size = 0;
    if (aDriver->m_transfer) {
      // Sizeof noch bestimmen
      FREEMem (aDriver->m_transfer,GETTRANSSIZE);
      aDriver->m_transfer = (WD_TRANSFER *) NULL;
    };
  }; // if aDriver
};
void JDriverFree(pJDriver aDriver)
{
  if (aDriver !=NULL) {
    JDriverDone(aDriver);
    FREEMem(aDriver, sizeof(tJDriver));
  };
};
int JDriverOpen(pJDriver aDriver)
{ int rt = -1;
  WD_LICENSE lic;
  if (aDriver !=NULL) {
    if (aDriver->hWD == (HANDLE) NULL) {
      aDriver->hWD = WD_Open();
      if (aDriver->hWD == INVALID_HANDLE_VALUE) {
           aDriver->hWD = (HANDLE) NULL;
           WRITEError("Driver not found !");
           return( rt );
      }
//      WD_LICENSE lic;
//      UT_STR::Copy(lic.cLicense, "68c861bd2c9cf034491860c33719380e.Xilinx");
        strcpy(lic.cLicense, "68c861bd2c9cf034491860c33719380e.Xilinx");
        WD_License(aDriver->hWD, &lic);
    }
  rt = 0;
  }; // aDriver
  return(rt);
};
void JDriverClose(pJDriver aDriver)
{ if (aDriver !=NULL) {
    WD_Close( aDriver->hWD );
    aDriver->hWD = (HANDLE) NULL;
  };
};
int JDriverGetParallelPorts(pJDriver aDriver, DWORD port_index )
{ int rt = -1;
  WD_CARD_REGISTER cardReg;
  BOOLEAN pc98 = FALSE;
  BYTE slash;
    if (JDriverOpen(aDriver) == -1) {
      return( rt );
    };// Open
 // get the pc type, PC98 or AT Compatible

  // The best way to distinguish between AT compatibles and PC-9800
  // is to check the data following the ROM BIOS entry point (FFFF:0000).
  // This area*s data format is shown below. The date is written
  // in ASCII code, so when the separator "/" (2Fh in hexadecimal)
  // is not present, it is PC-9800.
  // One should check FFFF:0007 and FFFF:000A. This detection method
  // assumes that machines other than AT compatibles are PC-9800.

  // Address            Length          AT Compatibles          PC-9800
  // FFFF:0000  5 Bytes         JMP far                         JMP far
  // FFFF:0005  8 Bytes         Date 'mm/dd/yy'         Not used
  // FFFF:000D  1 Byte          Not used                        Not used
  // FFFF:000E  1 Byte          Model ID                        ROM checksum
  // FFFF:000F  1 Byte          Reserved                        ROM checksum

  cardReg.Card.dwItems = 1;
  cardReg.fCheckLockOnly = FALSE;
  cardReg.Card.Item[0].item = ITEM_MEMORY;
  cardReg.Card.Item[0].fNotSharable = FALSE;
  cardReg.Card.Item[0].I.Mem.dwBytes = 1;
  cardReg.Card.Item[0].I.Mem.dwPhysicalAddr = 0xFFFF7;

  WD_CardRegister (aDriver->hWD, &cardReg);

  if(cardReg.hCard) {
    BYTE *ptr;

    ptr = (BYTE *) cardReg.Card.Item[0].I.Mem.dwUserDirectAddr;

//    BYTE slash = *ptr;               // at location 7
           slash = *ptr;               // at location 7

    if(slash == '/') {
      slash = *(ptr+=3);
      if(slash == '/') {
        pc98 = FALSE;
      } else {
        pc98 = TRUE;
      }
    } else {
      pc98 = FALSE;
    }
  } else {
    JDriverClose( aDriver );
    return( -1 );
  }
  WD_CardUnregister(aDriver->hWD, &cardReg);

  if (pc98) {
    aDriver->jcab_base_port = PC98_BASE_IO_ADDR;
    aDriver->io_increment = 2;
  } else {
    aDriver->io_increment = 1;

    // setup WinDrv to read physical memory
    cardReg.Card.dwItems = 1;
    cardReg.Card.Item[0].item = ITEM_MEMORY;
    cardReg.Card.Item[0].fNotSharable = FALSE;
    cardReg.Card.Item[0].I.Mem.dwBytes = 6;
    cardReg.fCheckLockOnly = FALSE;

    // check for LPT1, LPT2 and LPT3
    cardReg.Card.Item[0].I.Mem.dwPhysicalAddr = LPT_BASE_MEM_ADDR; // 0x00000408
    WD_CardRegister( aDriver->hWD, &cardReg );
    if (cardReg.hCard) {
      WORD *ptr;

      ptr = (WORD *) cardReg.Card.Item[0].I.Mem.dwUserDirectAddr;
       aDriver->jcab_base_port = ptr[port_index];
    } else {
         JDriverClose( aDriver );
         return( -1 );
    }
    WD_CardUnregister(aDriver->hWD, &cardReg);
  }
  return( aDriver->jcab_base_port );
};  // JDriverGetPorts
BOOLEAN JDriverWRTransfer(pJDriver aDriver, LPBYTE pOutBuf, LPBYTE pInBuf, DWORD dwSize )
{
  DWORD increment = 0;
  DWORD m_dwTransferSize = 0;
  DWORD j = 0;
  DWORD k = 0;
  DWORD i = 0;
  if (aDriver->m_transfer == (WD_TRANSFER *) NULL) {
    aDriver->m_transfer =  (WD_TRANSFER *)GETMem(GETTRANSSIZE);
    FILLChar(aDriver->m_transfer,0,GETTRANSSIZE);
  }

  m_dwTransferSize = aDriver->max_write_size;
  if (pInBuf) {

    // both input and output bytes are counted

    increment = 2;
    dwSize *= 2;
  } else {
    increment = 1;
  }

  if (dwSize < m_dwTransferSize) {

    // send the whole thing

    m_dwTransferSize = dwSize;
  }

//  DWORD j = 0;
//  DWORD k = 0;
          j = 0;
          k = 0;
  while (dwSize > 0) {
      for ( i = 0; i < m_dwTransferSize; i+=increment, j++ ) {
        aDriver->m_transfer[i].cmdTrans = WP_BYTE;
        aDriver->m_transfer[i].dwPort = GETDataPort(aDriver);
        aDriver->m_transfer[i].Data.Byte = pOutBuf[j];

        if (pInBuf) {
          aDriver->m_transfer[i+1].cmdTrans = RP_BYTE;
          aDriver->m_transfer[i+1].dwPort = GETStatusPort(aDriver);
          aDriver->m_transfer[i+1].Data.Byte = 0x0;
        }
      }
      WD_MultiTransfer( aDriver->hWD, aDriver->m_transfer, m_dwTransferSize );

      if (pInBuf) {
        for ( i = 0; i < m_dwTransferSize; i+=increment, k++ ) {
          pInBuf[k] = aDriver->m_transfer[i+1].Data.Byte;
        }
      }

      dwSize -= m_dwTransferSize;
      if (dwSize < m_dwTransferSize) {

        // send the whole thing

        m_dwTransferSize = dwSize;
      }
  }

  return( TRUE );
};
BYTE JDriverReadByte(pJDriver aDriver, DWORD dwIOAddr )
{  WD_TRANSFER trns;

  trns.cmdTrans = RP_BYTE;
  trns.dwPort = dwIOAddr;
  WD_Transfer( aDriver->hWD, &trns );
  return( trns.Data.Byte );

};
BYTE JDriverWriteByte(pJDriver aDriver, DWORD dwIOAddr, BYTE bData )
{  WD_TRANSFER trns;

  trns.cmdTrans = WP_BYTE;
  trns.dwPort = dwIOAddr;
  trns.Data.Byte = bData;
  WD_Transfer( aDriver->hWD, &trns );
  return( trns.Data.Byte );

};

