/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#ifndef __bscandrv__
#define __bscandrv__
#include "libenv.h"
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <winioctl.h>
#include "windrvr.h"
// Max. Buffer Size in Byte for Driver Buffer aCtrl->mBurstInfo
#define tapBURSTSIZE   4096 // TDI/TDO Buffer Size
#define tapBURSTEND      16 // need space for TMS-Sequenz after shifting data
// Structures to access the driver
// Write buffer bits
#define bsdrvTDI  0x01   // TDI value
#define bsdrvTCK  0x02   // TCK value
#define bsdrvTMS  0x04   // Tms VALUE
#define bsdrvCtrl 0x08   // TCK/TMS/TDI control low activ
#define bsdrvOne  0x10   // must be one always
//      bit5      0x20   // not assigned
#define bsdrvAck  0x40   // ACK Bit
//      bit7      0x80   // not used
// ReadBuffer
//      bit0      0x01   // not used
//      bit1      0x02   // not used
//      bit2      0x04   // not used
#define bsdrvVCC  0x08   // 1 if VCC detected
#define bsdrvTDO  0x10   // 1 if TDO is HIGH
#define bsdrvPend 0x20   // 1 if ACK = pend is sensed
//           ACK  0x40   // not assigned
#define bsdrvBusy 0x80   // 1 if ACK = busy is sensed
// Constants for Driver

//----------------------------------------------------------------------*/
// Base memory address containing the installed port IO addresses */
//----------------------------------------------------------------------*/

#define LPT_BASE_MEM_ADDR      0x0408;

//----------------------------------------------------------------------*/
// Only legal port IO address on PC98 machine  */
//----------------------------------------------------------------------*/

#define PC98_BASE_IO_ADDR  0x40;

//----------------------------------------------------------------------*/
// IO Port offsets from base for parallel port functions
//----------------------------------------------------------------------*/
#define DATA_OFFSET(aDriver)   \
    (0*aDriver->io_increment)
#define STATUS_OFFSET(aDriver) \
    (1*aDriver->io_increment)
#define CONTROL_OFFSET(aDriver)\
    (2*aDriver->io_increment)
// transfer buffer size
#define GETTRANSSIZE aDriver->m_dwBufferSize*sizeof(WD_TRANSFER)
// Structure of Burst Execution

typedef struct _tBurstInfo {
  long mImgSize;               // Size of Image buffer
  long mBufferEnd;              // End of Image  buffer
  pByte mTdo;            // Pointer to TDO Buffer -- Read
  pByte mTdi;            // Pointer to TDI Buffer -- Write
  pByte mExpect;          // Pointer to Expect value buffer
  long mCount;            // Counter of the TDI and TDO buffer
  long mExpectCount;      // Counter of the Expect Buffer
  long mStep;             // Number of bytes to output for one TCK-Step
  // Buffered output and input
  pByte mDrvOutput;       // Output buffer to output the whole bytes
  pByte mDrvInput;        // Get the data from the driver
  long  mDrvSize;         // Memory
  long  mDrvCount;
  } tBurstInfo, *pBurstInfo;
typedef struct _tJDriver {
  HANDLE hWD;
  DWORD io_increment;
  DWORD jcab_base_port;
  DWORD max_write_size;
  DWORD m_dwBufferSize;
  WD_TRANSFER *m_transfer;
} tJDriver, *pJDriver;

// Burst Functions
  void InitBurstInfo(pBurstInfo aInfo, long  aSize);
  pBurstInfo NewBurstInfo(long aSize);
  void FreeBurstInfo(pBurstInfo aInfo);
  void DoneBurstInfo(pBurstInfo aInfo);
// Init the buffered output and input buffer
  void InitDrvBuffer(pBurstInfo aInfo, long aSize);
  void FreeDrvBuffer(pBurstInfo aInfo);
// JDriver Class Functions ported to ANSI C
pJDriver JDriverNew();
void JDriverInit(pJDriver aDriver);
void JDriverDone(pJDriver aDriver);
void JDriverFree(pJDriver aDriver);
int  JDriverOpen(pJDriver aDriver);
void JDriverClose(pJDriver aDriver);
int  JDriverGetParallelPorts(pJDriver aDriver, DWORD port_index );
BOOLEAN JDriverWRTransfer(pJDriver aDriver, LPBYTE pOutBuf, LPBYTE pInBuf, DWORD dwSize );
BYTE    JDriverReadByte(pJDriver aDriver, DWORD dwIOAddr );
BYTE    JDriverWriteByte(pJDriver aDriver, DWORD dwIOAddr, BYTE bData );
// inline Functions as Macros
#define GETStatusPort(p) \
   p->jcab_base_port + STATUS_OFFSET(p)
#define GETDataPort(p) \
   p->jcab_base_port + DATA_OFFSET(p)

#define GETControlPort(p) \
   p->jcab_base_port + CONTROL_OFFSET(p)

#endif
