/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#ifndef __bscanio__
#define __bscanio__
#include "bscandrv.h"

#define tapMAXRESET       5  // Goto RESET with TMS HIGH default is 5
#define DCLOOPS 10000
typedef  enum {
   tapNoState   = -1,  // The state is undefined
   tapReset     =  0,
   tapIdle      =  1,
   // DR
   tapSelectDR  =  2,
   tapCaptureDR =  3,
   tapShiftDR   =  4,
   tapExit1DR   =  5,
   tapPauseDR   =  6,
   tapExit2DR   =  7,
   tapUpdateDR  =  8,
   // IR
   tapSelectIR  =  9,
   tapCaptureIR = 10,
   tapShiftIR   = 11,
   tapExit1IR   = 12,
   tapPauseIR   = 13,
   tapExit2IR   = 14,
   tapUpdateIR  = 15
}  tTapState;
// Boundary Scan Engine
typedef  struct _tBscanEngine  {
  tTapState mTMSHigh;           // High
  tTapState mTMSLow;             // Low
} tBscanEngine, *pBscanEngine;

// Boundary Scan Controller

typedef struct _tBscanController  {
 int mHaltState;
 pJDriver mDriver;  // Bscan-driver
 int mStatus;       // status of the port
 unsigned long mPortIndex; // Port Id
 tBurstInfo mBurstInfo;    // Burst Buffer
 tTapState mTapState;      // Current controller state
 pBscanEngine mBscanGraph;
 double mMaxCallsPerMS;
} tBscanController, *pBscanController;

// Functions to Handle the boundary Scan Driver abstractly
int  BScanCtrlInit( pBscanController aCtrl );
void BScanCtrlClose( pBscanController aCtrl);
tByte BScanCtrlReadByte(pBscanController aCtrl);
void  BScanCtrlWriteByte(pBscanController aCtrl,tByte aByte);
int   BScanCtrlCheckCable(pBscanController aCtrl);
int   BScanCtrlBurstExecute(pBscanController aCtrl,int aReadBack);
void WriteClocks(pBscanController aCtrl, long aCount);
// delay functions
void InitDelay(pBscanController aCtrl);
void DelaySeconds(pBscanController aCtrl, double aSeconds);

// ******************* State Engine ***************************
// This functions are not depend from hardware
int GotoNextState(pBscanController aCtrl, int aTms);
#endif
