/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#include "libenv.h"
#include "executor.h"
#include "bscandrv.h"
#include "bscanio.h"
#include "logfkt.h"
int ResetExecutor(pExecutor apExecutor);
/***** scan info block functions **********************************************/
// Constructor for Executor
pExecutor InitExecutor()
{

    pExecutor vExecutor = (pExecutor)GETMem(sizeof(tExecutor));
    FILLChar(vExecutor, 0, sizeof(tExecutor));

    #ifdef VIRTUAL
        if (ISVirtual)
        {
            vExecutor->mStartIndex = 0;
            return vExecutor;
        }
    #endif

   vExecutor->mStatus = BScanCtrlInit(&vExecutor->mCtrl);
   if ((vExecutor != NULL) && (vExecutor->mStatus == rtOk))
     TapReset (vExecutor);
     InitDelay(&vExecutor->mCtrl);
     vExecutor->mOptions |= exeoptHALTState;
     // Set the halt-state
     // if one device in the chain with halt-state
         // of TCK is LOW -> 3 byte output Low high low
     vExecutor->mCtrl.mHaltState =
      (vExecutor->mOptions & exeoptHALTState?1:0);
   vExecutor->mCtrl.mBurstInfo.mStep = (vExecutor->mCtrl.mHaltState?2:3);
    return vExecutor;
};
int ExeDone(pExecutor apExecutor)
{
  if (apExecutor != NULL)
    {
        #ifndef VIRTUAL
            if (!ISVirtual)
                BScanCtrlClose(&apExecutor->mCtrl);
        #endif
    //    BScanCtrlClose(&apExecutor->mCtrl);
        FREEMem(apExecutor,sizeof(tExecutor));
  };
  return 0;
};

int SetExecutorCode(pExecutor apExecutor, tCode aGlobalCode)
{int rt = rtOk;
    #ifdef VIRTUAL
        if (ISVirtual)
            return rtOk;
    #endif

    ResetExecutor(apExecutor);
 // Set the new code and make some TMS Step if required
    apExecutor->mCode = aGlobalCode;
      switch (apExecutor->mCode) {
        case doIrScan:
           GotoShiftIR(apExecutor);
            break;
        case doDrScanIn:
         GotoShiftDR(apExecutor);
            break;
        case doDrScanOut:
         GotoShiftDR(apExecutor);
            break;
        case doSetTAPState:
            break;
        case doTAPReset:
          ; // Call by Executor function
            break;
        case doWait:
         GotoRunIdle(apExecutor);
            break;
     };// switch
    // Set the startindex of burst running from 0 to Count - 1
    apExecutor->mStartIndex = apExecutor->mCtrl.mBurstInfo.mCount;
 return(rt);
}; // SetE xe

int Execute(pExecutor apExecutor, int aComplete, int *vExecutorError)
{

int rt= rtOk;
    #ifdef VIRTUAL
        if (ISVirtual)
        {
            *vExecutorError = rtOk;
            return rtOk;
        }
    #endif
// Some TMS-Sequences have to be written in the buffer
apExecutor->mUseReserve = !aComplete;
apExecutor->mComplete = aComplete;

  switch (apExecutor->mCode)
    {
        case doIrScan:
        case doDrScanIn:
           rt =  ExeScanDR(apExecutor, vExecutorError);
            break;
        case doDrScanOut:
           rt =  ExeScanDR(apExecutor, vExecutorError);
            break;
        case doSetTAPState:
            break;
        case doTAPReset:
           rt = TapReset (apExecutor);
            break;
        case doWait:
           rt =  ExeWait(apExecutor);
            break;
    }
    return(rt);
}

int ResetExecutor(pExecutor apExecutor)
{
    #ifdef VIRTUAL
        if (ISVirtual)
            return rtOk;
    #endif
     // Reserve buffer not used
   apExecutor->mUseReserve = 0;
   // Buffer Counter Init
    apExecutor->mCtrl.mBurstInfo.mCount = 0L;
    apExecutor->mCtrl.mBurstInfo.mExpectCount = 0L;
   apExecutor->mStartIndex = 0L;
    // Set the starting Index of Scan-Data
   return 0;
}
int ReInitExecutor(pExecutor apExecutor)
{
  tByte vZero = 0;
    tByte vTmsHigh = bitTMS;

    #ifdef VIRTUAL
        if (ISVirtual)
            return rtOk;
    #endif

  ResetExecutor(apExecutor);
  if (EXOADDClocks(apExecutor->mOptions)) {
       AddTMSStep(apExecutor,&vTmsHigh);
       AddTMSStep(apExecutor,&vZero);
       apExecutor->mStartIndex = apExecutor->mCtrl.mBurstInfo.mCount;
  }
  return 0;
}
// Set one byte
void SetTCKClockInfoBit(pByte aTCKClockInfo, int aBit)
{
    #ifdef VIRTUAL
        if (ISVirtual)
            return rtOk;
    #endif

    if ((aBit == bitTDO) || (aBit == bitTDIExpected) || (aBit == bitTDIMask)
            || (aBit == bitTDIMeasured))
        *aTCKClockInfo = *aTCKClockInfo | aBit;

    if ((aBit == bitTDO_0) || (aBit == bitTDIExpected_0) || (aBit == bitTDIMask_0)
            || (aBit == bitTDIMeasured_0))
        *aTCKClockInfo = *aTCKClockInfo & aBit;
}
int AddTMSStep(pExecutor aExec, pByte aByte)
{ tByte vZero = 0x00;
  AddTCKClockInfoTDO(aExec,aByte);
  // Add a Zero Byte for syncrone buffers
  AddTCKClockInfoTDI(aExec,&vZero);
  return 0;
};
int AddTCKClockInfoTDO(pExecutor aExecutor, pByte aTCKClockInfo)
{int rt = 1;
int  vTms = (*aTCKClockInfo & bitTMS?1:0);
 pBscanController coCtrl;
 pBurstInfo coBuInf;
 int vEnde;

    #ifdef VIRTUAL
        if (ISVirtual)
            return 0;
    #endif

    coCtrl = &aExecutor->mCtrl;
 coBuInf = &aExecutor->mCtrl.mBurstInfo;
 vEnde = (aExecutor->mUseReserve?coBuInf->mImgSize:coBuInf->mBufferEnd);

   // Get the next state in state engine
   GotoNextState(coCtrl,vTms);
   // Check the Buffer and return value
    if ((aExecutor != NULL) && (coBuInf->mTdi != NULL))
        if (coBuInf->mCount < vEnde) {
#ifdef XILINX_CABLE
             // Set the driver bit, allways to one
             // Driver specific condition
             *aTCKClockInfo |= (bsdrvOne | bitTCK);
#endif
            coBuInf->mTdi[coBuInf->mCount] = *aTCKClockInfo;
            coBuInf->mCount++;
         rt = 0;
        }
    return rt;
};
int  GetTDIIndex(pExecutor aExecutor)
{ int vIndex;
    #ifdef VIRTUAL
        if (ISVirtual)
            return 1;
    #endif
    vIndex = aExecutor->mEndIndex;
  return(vIndex);
};
int  GetTCKClockInfoTDI(pExecutor aExecutor,int aIndex, pByte aByte)
{
int rt = rtErr;
int vEnde;

    #ifdef VIRTUAL
        if (ISVirtual)
            return 1;
    #endif
 vEnde = (aExecutor->mUseReserve?aExecutor->mCtrl.mBurstInfo.mImgSize:
                                     aExecutor->mCtrl.mBurstInfo.mBufferEnd);

 if ((aIndex >=0) && (aIndex <vEnde)) {
   rt = rtOk;
   *aByte = aExecutor->mCtrl.mBurstInfo.mTdo[aIndex];
 };
 return(rt);
};
int AddTCKClockInfoTDI(pExecutor aExecutor, pByte aTCKClockInfo)
 {int rt = 1;
    int vEnde;
    pBscanController coCtrl;
    pBurstInfo coBuInf;

    #ifdef VIRTUAL
        if (ISVirtual)
            return 0;
    #endif
 vEnde = (aExecutor->mUseReserve?  aExecutor->mCtrl.mBurstInfo.mCount:
                                                                                aExecutor->mCtrl.mBurstInfo.mBufferEnd);
 coCtrl = &aExecutor->mCtrl;
 coBuInf = &aExecutor->mCtrl.mBurstInfo;

    if ((aExecutor != NULL) && (coBuInf != NULL))
        if (coBuInf->mExpectCount < vEnde)
        {
            coBuInf->mExpect[coBuInf->mExpectCount] = *aTCKClockInfo;
            coBuInf->mExpectCount++;
      /////////////////////////////////////////////////////////////////////////
            // habe return-Werte vertauscht -> siehe AddTCKClockInfoTDO
            rt = 0;
        }
    return rt;
};
/***** Execution **************************************************************/
int ExeScanCompare(pExecutor aExec)
{int rt = rtOk;
 int vIdx;
 tByte vCompare  = 0x00;
 tByte vByte = 0x00;
 tByte vFail  = 0x00;
 tByte vBitM   = 0x00;
 tByte vBitE   = 0x00;
 pBurstInfo coBuInf = &aExec->mCtrl.mBurstInfo;
 int vCount = coBuInf->mCount;
 for (vIdx = 0;vIdx < vCount -1;vIdx++) {
   vByte = coBuInf->mTdo[vIdx];
   vCompare = coBuInf->mExpect[vIdx];
   // Compare the Data
   if (vCompare & bitTDIMask) {
     vBitM = (vByte & bitTDIMeasured?1:0);
     vBitE = (vCompare & bitTDIExpected?1:0);
     vFail =  vBitM != vBitE ;
    if (vFail) {
     rt = rtErr;
     coBuInf->mTdo[vIdx] |= bitFail;
    };
   };
 };
 return(rt);
};
int ExeScanDR(pExecutor apExecutor,int *aResult)
{  int rt = rtOk;
   tByte vZero = 0x00;
   int vTmsHigh = bitTMS;
   pBurstInfo coBuInf = &apExecutor->mCtrl.mBurstInfo;
   pBscanController coCtrl = &apExecutor->mCtrl;
   int vCount = coBuInf->mCount;
   if (apExecutor->mCode != doIrScan)
     if (coBuInf->mCount != coBuInf->mExpectCount) {
       rt = rtErr;
       WRITEError("Index-Error in ScanDr\n Count: %d Expect cout: %d\n",
         coBuInf->mCount,
         coBuInf->mExpectCount
       );
     };
   // Set the end of buffer for DRSCAN OUT
   apExecutor->mEndIndex = vCount;
   if (apExecutor->mComplete) {
     coBuInf->mTdi[vCount - 1] |= bitTMS; // Step to EXIT1
     GotoNextState(coCtrl,1);
     if (EXOADDClocks(apExecutor->mOptions))
        AddTMSStep(apExecutor,&vZero);     // stay in DR-Pause
   } else {
    // the case of full buffer and scan operation is not complete
    // Goto DRPAUSE
      if (EXOADDClocks(apExecutor->mOptions)) {
         coBuInf->mTdi[vCount - 1] |= bitTMS; // Step to EXIT1
         GotoNextState(coCtrl,1);
         AddTMSStep(apExecutor,&vZero);     // stay in DR-Pause
      } else {
     // nothing
      };
   }; // if complete
   if (rt == rtOk)
     rt = BScanCtrlBurstExecute(&apExecutor->mCtrl,
            apExecutor->mCode == doDrScanOut
          );
   if (rt == rtOk)
     if (apExecutor->mCode == doDrScanOut) {
       *aResult = ExeScanCompare(apExecutor);
     };
    return (rt);
}

int ExeSetTAPState(pExecutor apExecutor)
{int rt = rtOk;
    return (rt);
}

int ExeWait(pExecutor apExecutor)
{ int rt = rtOk;
  double vMicroSec = apExecutor->mWaitTime;
  // Wait for defined time
  rt = BScanCtrlBurstExecute(&apExecutor->mCtrl,0);
  WriteClocks(&apExecutor->mCtrl, apExecutor->mWaitCycleCount);
  if (vMicroSec > 0.0) {
    // Calc Micro Sec from Sec
    DelaySeconds(&apExecutor->mCtrl, vMicroSec);
  };
  return (rt);
};
int ExeNoOp(pExecutor apExecutor)
{int rt = rtOk;
 return(rt);
};

int TapReset (pExecutor aExec)
{ int rt = rtErr;
  int idx;
  tByte vTMSHigh = bitTMS;
  tByte vTMSLow  = 0x00;
  if (aExec != NULL) {
    for (idx = 0;idx < tapMAXRESET ;idx++ )  {
      AddTMSStep(aExec,&vTMSHigh);
    };// for

   // Tap-Reset: the buffr BurstInfo and TCKInfo
   // syncrone before first operation comes
   // Goto Idle
   AddTMSStep(aExec,&vTMSLow);
   BScanCtrlBurstExecute(&aExec->mCtrl,0);
   rt = rtOk;
  };// aCtrl
 return(rt);
};
int GotoShiftDR(pExecutor aExec)
{ int rt = rtOk;
  tByte vTMSHigh = bitTMS;
  tByte vTMSLow  = 0x00;

  switch (aExec->mCtrl.mTapState) {
   case tapPauseIR :
   case tapPauseDR :
      AddTMSStep(aExec, &vTMSHigh); // Exit2     IR/DR
   case tapExit1DR:
   case tapExit1IR:
      AddTMSStep(aExec, &vTMSHigh); // Update    IR/DR
   case tapIdle :
      AddTMSStep(aExec, &vTMSHigh); // Select    DR
      AddTMSStep(aExec, &vTMSLow); // Capture   DR
      AddTMSStep(aExec, &vTMSLow); // Shift     DR
      break;
   default :
      rt = rtErr;
      break;
  }  // switch
  return(rt);
};
int  GotoShiftIR(pExecutor aExec)
{  int rt = rtOk;
  tByte vTMSHigh = bitTMS;
  tByte vTMSLow  = 0x00;

   switch (aExec->mCtrl.mTapState) {
   case tapPauseIR :
   case tapPauseDR :
      AddTMSStep(aExec, &vTMSHigh); // Exit2    IR/DR
   case tapExit1DR:
   case tapExit1IR:
      AddTMSStep(aExec, &vTMSHigh); // Update   IR/DR
   case tapIdle :
      AddTMSStep(aExec, &vTMSHigh); // Select   DR
      AddTMSStep(aExec, &vTMSHigh); // Select   IR
      AddTMSStep(aExec, &vTMSLow); // Capture   IR
      AddTMSStep(aExec, &vTMSLow); // Shift     IR
      break;

   default :
       rt = rtErr;
       break;
   } // switch
 return(rt);
}
int  GotoRunIdle(pExecutor aExec)
{int rt = rtOk;
  tByte vTMSHigh = bitTMS;
  tByte vTMSLow  = 0x00;

  switch (aExec->mCtrl.mTapState) {
  case tapReset:
      AddTMSStep(aExec, 0);
    break;
  case tapIdle:
    break;
  case tapPauseDR:
  case tapPauseIR:
      AddTMSStep(aExec, &vTMSHigh);  // .. Exit2
      AddTMSStep(aExec, &vTMSHigh);  // .. update
      AddTMSStep(aExec, &vTMSLow);       // Run Idle
    break;
  case tapExit1IR:
  case tapExit1DR:
      AddTMSStep(aExec, &vTMSHigh);  // .. update
      AddTMSStep(aExec, &vTMSLow);       // Run Idle
  default :
    rt = rtErr;
    break;
  }; // switch
  return 0;
};

