/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#ifndef __Executor__
#define __Executor__
#include "bscanio.h"
/***** constants **************************************************************/

// TCK clock info bits
// Abstract value          driver depend value
//-----------------------------------------------
// Outputbuffer
#define bitTCK             bsdrvTCK
#define bitTMS             bsdrvTMS
#define bitTDO             bsdrvTDI
#define bitTDO_0                0xFE    // Mask of TDO
// Expect buffer is an abstract buffer
#define bitFail            0x01
#define bitTDIExpected      0x02  // 0000 0010
#define bitTDIMask          0x04  // 0000 0100
#define bitTDIExpected_0  0xFD  // Mask of TDI Exp
#define bitTDIMask_0            0xFB    // Mask of TDIMASK

// Read back buffer
#define bitTDIMeasured      bsdrvTDO
#define bitTDIMeasured_0    0xEF

/***** data types *************************************************************/
typedef enum _tCode
{
    doReady = 0,
    doNoOp,
    doIrScan,
    doDrScanIn,
    doDrScanOut,
    doSetTAPState,
  doTAPReset,
    doWait
} tCode;

typedef tByte tTCKClockInfo;
#define exeoptADDCLOCKS   0x01
// This Options are defined in bscanio.h
#define exeoptHALTState   0x02
#define exeoptHALTState_0 0xFD
// Set the ADD-Clock Option
#define EXOADDClocks(aOpt) exeoptADDCLOCKS & (aOpt)
typedef struct _Executor
{
    tCode mCode;
   int mStatus;
   tByte mComplete;
   tByte mUseReserve; // 1: Buffer end = mSize
                      // 0: Buffer end = Bufferend
    double mWaitTime;
    int mWaitCycleCount;
   tBscanController mCtrl;
   int mOptions;
   int mStartIndex;   // begin of Data
   int mEndIndex;
} tExecutor, *pExecutor;

/***** function prototypes ****************************************************/
// . Executor
pExecutor InitExecutor(void);
int SetExecutorCode(pExecutor apExecutor, tCode aGlobalCode);
int Execute(pExecutor aExecutor, int aComplete, int *vExecutorError);
int ReInitExecutor(pExecutor apExecutor);
// . TCK info
void SetTCKClockInfoBit(pByte aTCKClockInfo, int aBit);
// Fill the buffer
// Write Buffer TDO-Controller
int AddTCKClockInfoTDO(pExecutor aExecutor, pByte aTCKClockInfo);
// Read Buffer TDI-Controller and Expectbuffer

int GetTCKClockInfoTDI(pExecutor aExecutor,int aIndex, pByte aByte);
// Return the current index of TDI-Buffer:
// Execute - GetTdiCount - ReInit
int  GetTDIIndex(pExecutor aExecutor);
int AddTMSStep(pExecutor aExec, pByte aByte);
int AddTCKClockInfoTDI(pExecutor aExecutor, pByte aTCKClockInfo);

// . Execution
int ExeScanIR(pExecutor apExecutor);
int ExeScanDR(pExecutor apExecutor,int *aResult);
int ExeScanCompare(pExecutor aExec);
int ExeSetTAPState(pExecutor apExecutor);
int ExeWait(pExecutor apExecutor);
int ExeDone(pExecutor apExecutor);
int TapReset (pExecutor aExec);
int GotoShiftDR(pExecutor aExec);
int GotoShiftIR(pExecutor aExec);
int GotoRunIdle(pExecutor aExec);

#endif