/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#include "pdata.h"
#include "interpr.h"
#include "libenv.h"
#include "progty.h"

/* -------------------------------------------------------------------------- */
/* --- vector synthesizer - init and main loop for device programming     --- */
/* -------------------------------------------------------------------------- */
int VectorSynthesizer(pProg1532 aProg1532, int aOptions)
{
    int i, vActionCount;
    int vReady, vReadDevParam, vReadParam, vDevIndex, vTDIIndex;
    int vDeviceCount = GetDeviceCount(aProg1532);
    int vError = rtOk;
    int vExecutorError = rtOk;
    int vFailError = 0;
    int vInitErrorProc = 1;
/*
Frank Phillips @ XIlinx added  the following two varibles to enable 
sequential/concurrent programming modes on 
May_06_2001
*/
    int vSeqDeviceNumber, vProgSequentialFlag, vSequentialDoReady;
/* FP_DEBUG  */
	int linecount = 0, time ;
    pDevEnt vpDevice;
    pActionStatus vpStatus;
    tByte vTCKClockInfo;
    int vReturn = rtOk;
	int RegLenPdata;
    #ifdef DEBUG
        TSTRING vMeasuredBits;
        TSTRING vFailBits;
    #endif

    pExecutor vExecutor;
    pCodeList vCodeList;
    tCode vGlobalCode, vGlobalEnableFlag, vGlobalDisableFlag;
 
	vGlobalEnableFlag = 0;
	vGlobalDisableFlag = 0;
    vSeqDeviceNumber = 0;
    vProgSequentialFlag = 0;
    vSequentialDoReady = 0;

	// Checking and setting Programming Modes
	// Added By Frank Phillips @ Xilinx on
	// May_10_2001  
	if (aProg1532->progMode == 1)
		vProgSequentialFlag = 0;
	else if (aProg1532->progMode == 2)
		     vProgSequentialFlag = 1;

    // init executor and codelist
    vExecutor = InitExecutor();
    vCodeList = InitCodeList(vDeviceCount);
    if (vExecutor->mStatus)
        return rtErr;

    // set add clocks
    if (aOptions & vsOptAddClocks)
    vExecutor->mOptions |= exeoptADDCLOCKS;

    // init action per device
	vActionCount = 0;
    for (i = 0; i < vDeviceCount; i++)
    {
        vpDevice = GetDeviceAtIndex(aProg1532, i);
		vpStatus = ACTIONStatusOfDevice(vpDevice);
        // set tck signal status (global for executor)
        if (DEVICETCKSignalStatus(vpDevice) == tckLow)
            vExecutor->mOptions |= exeoptHALTState;
        // init code loop per device
        if (InitCodeLoop(vpDevice, &vActionCount))
            return rtErr;
		// If sqential set the current one disable others  Frank Phillips @ Xilinx on
		// May_10_2001
		if(vProgSequentialFlag) {
			EXECUTEDCodes[i] = doNoOp;
		    IscDisableCodes[i] = 0;
			if(i == vSeqDeviceNumber) 
				EXECUTEDCodes[i]=doReady;
        }
		// if no action specified set ISC_DIABLE flag  Frank Phillips May_06_2001
		if (vpStatus->mAction == NULL) {
		    IscDisableCodes[i] = 1;
			EXECUTEDCodes[i] = doNoOp;
		}
	}
    // no action defined
    if (vActionCount == 0)
    {
        WRITEError("\n...Error - no action defined.\n");
        return rtErr;
    }
    // only one action allowed
/*
    if (vActionCount > 1)
    {
        WRITEError("\n...Error - only 1 action is allowed and %d are defined.\n",
            vActionCount);
        return rtErr;
    }

*/


    // execute
    vReady = 0;
    while (vReady == 0)
    {
		/*
         if(vProgSequentialFlag) {
			 printf(" Programming device %d -- %d\n", vDeviceNumber, linecount);
			 linecount++;
		 }
		 */
		// if fail error during execution --> init procedure proc_error_exit
        if (vFailError)
        {
            if (vInitErrorProc)
            {
                vInitErrorProc = 0;
        // ignore fail
                if (aOptions & vsOptIgnoreFail)
                {
                    for (i = 0; i < vDeviceCount; i++)
                    {
                    vpDevice = GetDeviceAtIndex(aProg1532, i);
                    vpStatus = ACTIONStatusOfDevice(vpDevice);
                    vpStatus->mResult = resIgnoreFail;
                    }
                }
        // init proc_error_exit
                else
                {
                    WRITEError("\n...Error - compare fail.\n");
                    vReturn = rtErr;
                    WriteProgrammingStatus(aProg1532);

                    for (i = 0; i < vDeviceCount; i++)
                        if (InitErrorProcedure(GetDeviceAtIndex(aProg1532, i)))
                            return rtErr;
                }
            }
        }

        // ask all devices for the next CODE to be executed
        for (i = 0; i < vDeviceCount; i++)
        {
            vpDevice = GetDeviceAtIndex(aProg1532, i);
			InitBypassParameter(vpDevice);
			
            if (((EXECUTEDCodes[i] != doNoOp) && (IscDisableCodes[i] == 0)) || vGlobalDisableFlag)
            {
                NEXTCodes[i] = GetNextCode(vpDevice, &vError);
                if (vError)
                {
                    WriteProgrammingStatus(aProg1532);
                    return rtErr;
                }

	 // For Concurrent: if next code is doIrScan then check for Instructions ISC_ENABLE & ISC_DISABLE

				if(!vProgSequentialFlag) {
					if(NEXTCodes[i] == doIrScan) {
						vpStatus = ACTIONStatusOfDevice(vpDevice);
						if(!vGlobalEnableFlag) {
							if(!STRCompare(vpStatus->mEnableInstruction, vpStatus ->mInstruction))
								IscEnableCodes[i] = 1;
						}
						if(!vGlobalDisableFlag) {
							if(!STRCompare(vpStatus->mDisableInstruction, vpStatus ->mInstruction)) {
								IscDisableCodes[i] = 1;

							}
						}
					} // end if ENABLE/DISABLE checks
				}// if vProgSequentialFlag
            }
        }

/* Frank Phillips @ Xilinx Added the following code to check if all the 
devices are enabled or disabled. If not, the disabled ones will be put on BYPASS
until all the devices are ready to execute ISC_DISABLE
May_01_2001 */
		vGlobalEnableFlag  = 1;
		vGlobalDisableFlag = 1;
		for (i = 0; i < vDeviceCount; i++) {

			if(IscEnableCodes[i] == 0)
				vGlobalEnableFlag = 0;

			if(IscDisableCodes[i] == 0)
				vGlobalDisableFlag = 0;
		}



        // checks the compatibility of the different CODEs of the devices
        // set the global CODE
/* Frank Phillips 	
        vGlobalCode = GetGlobalCode(vCodeList);
*/
		if(vProgSequentialFlag) {
			EXECUTEDCodes[vSeqDeviceNumber] = NEXTCodes[vSeqDeviceNumber];
		    SetExecutorCode(vExecutor, EXECUTEDCodes[vSeqDeviceNumber]);
		}
		else {
			vGlobalCode = GetGlobalCode(vCodeList, vGlobalCode);
		    SetExecutorCode(vExecutor, vGlobalCode);
		}

        #ifdef DEBUG
        if (LOGDebug)
        {	
			printf("HI dev%d  -- nCode = ", vSeqDeviceNumber);
			for (i=0; i < vDeviceCount; i++)
				printf("%d ", NEXTCodes[i]);
			printf(" - gCode= %d  - linecount = %d\n", vGlobalCode, linecount++);
			/*
			if(linecount == 5298)
			printf("HI -- STOP\n");
			time=1000000;
			for(i=0; i< time; i++);
			*/
        }
        #endif

		if(vProgSequentialFlag && EXECUTEDCodes[vSeqDeviceNumber] == 0)
			vSequentialDoReady = 1;
/*	
		if(vProgSequentialFlag && 
			((IscDisableCodes[vSeqDeviceNumber]==1) || 
			       (EXECUTEDCodes[vSeqDeviceNumber] == 0))) 
			vSequentialDoReady = 1;
*/
	    if ((vGlobalCode == doReady) || (vProgSequentialFlag && vSequentialDoReady))
        {
            vReady = 1;

            if(vProgSequentialFlag) {
			   vSequentialDoReady = 0;
			   vSeqDeviceNumber = vSeqDeviceNumber +1;


	           if(vSeqDeviceNumber <= vDeviceCount -1 ) {
                      vReady = 0;
			      
			  ExeDone(vExecutor);
		          vExecutor = InitExecutor();
//		          ReInitExecutor(vExecutor);
//		          vCodeList = InitCodeList(vDeviceCount);
			  if (vExecutor->mStatus)
        	            return rtErr;

			      if (aOptions & vsOptAddClocks)
                     vExecutor->mOptions |= exeoptADDCLOCKS;

                  // init action per device
	              vActionCount = 0;
				  for (i = 0; i < vDeviceCount; i++)
				  {
				     vpDevice = GetDeviceAtIndex(aProg1532, i);
					 vpStatus = ACTIONStatusOfDevice(vpDevice);
					 // set tck signal status (global for executor)
					 if (DEVICETCKSignalStatus(vpDevice) == tckLow)
					 	vExecutor->mOptions |= exeoptHALTState;

					 // init code loop per device
					 // No need to re-init. It will give false length by
					 // concatenating too many string of mByPassInstruction
					 // Frank Phillips @ Xilinx on
					 // May_14_2001
					 // if (InitCodeLoop(vpDevice, &vActionCount))
					 //	return rtErr;

					 // If sqential set the current one disable others  Frank Phillips @ Xilinx on
					 // May_10_2001
					 if(vProgSequentialFlag) {
					 	EXECUTEDCodes[i] = doNoOp;
					 	IscDisableCodes[i] = 0;
						if (i == vSeqDeviceNumber) 
							EXECUTEDCodes[i]=doReady;
					 }
					 // if no action specified set ISC_DIABLE flag  Frank Phillips May_06_2001
					 if (vpStatus->mAction == NULL) {
						IscDisableCodes[i] = 1;
						EXECUTEDCodes[i] = doNoOp;
					 }
				  }
			   }
			}
            continue;
			}

        // Requests to define the parameter of the global CODE
        // Adjusts the parameter of different devices
        // calls the executor with the vector interface data
        #ifdef DEBUG
        if (LOGDebug)
        {
            STRInit(vMeasuredBits, "");
            STRInit(vFailBits, "");
        }
        #endif

/* in Sequential Mode make Global code to be the current device code
Frank Phillips @ Xilinx Added on
May_08_2001
*/

        vReadParam = 0;
        vDevIndex = 0;
        while (vReadParam == 0)
        {
            vpDevice = GetDeviceAtIndex(aProg1532, vDevIndex);

			// sequential
			if(vProgSequentialFlag) {
                if((EXECUTEDCodes[vDevIndex]) == doNoOp) {
				    vReadDevParam = GetBypassParameter(vExecutor, vpDevice,
						EXECUTEDCodes[vSeqDeviceNumber], &vError);
				}
			 	else
                   vReadDevParam = GetNextParameter(vExecutor, vpDevice, &vError);
			}	
			// Concurrent 
			else {


			    // if one device is isc_disable then wait for all devices to be disabled
                if((!vGlobalDisableFlag) && (IscDisableCodes[vDevIndex] == 1)) {
				    vReadDevParam = GetBypassParameter(vExecutor, vpDevice, vGlobalCode,
                        &vError);
				// bypass for noop
				}
			    else if((vGlobalCode == doDrScanOut) && (EXECUTEDCodes[vDevIndex]) == doNoOp)
				    	vReadDevParam = GetNextForcedScanout(vExecutor, vpDevice, vGlobalCode, &vError);
//				    else if((vGlobalCode == doDrScanIn) && (EXECUTEDCodes[vDevIndex])== doNoOp)
				    else if((EXECUTEDCodes[vDevIndex])== doNoOp)	
					    vReadDevParam = GetBypassParameter(vExecutor, vpDevice, vGlobalCode,
                                &vError);
               
/*			
			else if((vGlobalCode == doDrScanOut) && (vGlobalCode != EXECUTEDCodes[vDevIndex]))
                vReadDevParam = GetNextForcedScanout(vExecutor, vpDevice, vGlobalCode, &vError);
*/
/*  Frank Phillips -- April 29 01 -- FP

            if (EXECUTEDCodes[vDevIndex] == doNoOp)
                vReadDevParam = GetBypassParameter(vExecutor, vpDevice, vGlobalCode,
                    &vError);
*/
            // parameter for current code
                else
                    vReadDevParam = GetNextParameter(vExecutor, vpDevice, &vError);
			}
// FP

            // abort, if getting parameter failed
            if (vError)
            {
                WriteProgrammingStatus(aProg1532);
                return rtErr;
            }

            // if executor buffer not full --> next device
            if (vReadDevParam)
            {
                vDevIndex++;
                if (vDevIndex == vDeviceCount)
                    vReadParam = 1;
            }

            // executor buffer full or read parameters from all devices
            if ((! vReadDevParam) || vReadParam)
            {
				// Pick the longest wait time
				if ((vGlobalCode == doWait) && (!vProgSequentialFlag))
				{
				  vDeviceCount = GetDeviceCount(aProg1532);
				  PickLongestWait(aProg1532,vExecutor,vDeviceCount, &vError);	
				}
                // abort, if picking  failed
				if (vError)
				{
					WriteProgrammingStatus(aProg1532);
					return rtErr;
				}
                // execute
                if (Execute(vExecutor, vReadParam, &vExecutorError))
                    return rtErr;
                vFailError = vExecutorError;

                #ifdef DEBUG
                    if (LOGDebug)
                        if (vReadParam)
                            WRITEDebug(" (EXECUTE)");
                        else
                            WRITEDebug(" (SHIFT)");
                #endif

                // in case of reading back: information from the device
                if ((vGlobalCode == doDrScanOut) ||
					    ((EXECUTEDCodes[vSeqDeviceNumber] == doDrScanOut)&&(vProgSequentialFlag)))
                {
                    #ifdef DEBUG
                        if (LOGDebug)
                        {
                            STRInit(vMeasuredBits, "");
                            STRInit(vFailBits, "");
                        }
                    #endif

                    vTDIIndex = GetTDIIndex(vExecutor);
                    for (i = vExecutor->mStartIndex; i < vTDIIndex; i++)
                    {
                        GetTCKClockInfoTDI(vExecutor, i, &vTCKClockInfo);

                        #ifdef DEBUG
                            if (LOGDebug)
                            {
                                if (vTCKClockInfo & bitTDIMeasured)
                                    STRAddChar(vMeasuredBits, '1');
                                else
                                    STRAddChar(vMeasuredBits, '0');
                                if (vTCKClockInfo & bitFail)
                                    STRAddChar(vFailBits, '1');
                                else
                                    STRAddChar(vFailBits, '0');
                            }
                        #endif
                    }
                    #ifdef DEBUG
                        if (LOGDebug)
                        {
                            WRITEDebug("\n          measured: ");
                            WriteStringBitField(&vMeasuredBits);
                            WRITEDebug("\n          fail:     ");
                            WriteStringBitField(&vFailBits);
                            STRDone(vMeasuredBits);
                            STRDone(vFailBits);
                        }
                    #endif
                }
                if (! vReadParam)
                    ReInitExecutor(vExecutor);
            }
        }
    }   // end while vReady
    ExeDone( vExecutor );
    DoneCodeList(vCodeList);
    return vReturn;
}

/******************************************************************************/
/***** global code                                                        *****/
/******************************************************************************/

/* -------------------------------------------------------------------------- */
/* --- checks the compatibility of the different CODEs of the devices     --- */
/* -------------------------------------------------------------------------- */
/* tCode GetGlobalCode(pCodeList apCodeList)
{
    int i;
    tCode vGlobalCode = doReady;

    for (i = 0; i < apCodeList->mCount; i++)
    {
        // noop if doReady
        if (apCodeList->mNextCodes[i] == doReady)
            apCodeList->mExecutedCodes[i] = doNoOp;
        // code to execute
        else
        {
            // global code = device code (only one action !!!)
            apCodeList->mExecutedCodes[i] = apCodeList->mNextCodes[i];
            vGlobalCode = apCodeList->mExecutedCodes[i];
        }
    }
 return vGlobalCode;
}
*/
tCode GetGlobalCode(pCodeList apCodeList, tCode vPastGlobalCode)
{
    int i, CodesSame, PreferCodeFound;
    tCode vGlobalCode, vPreviousDeviceCode, vNextGlobalCode;

    vPreviousDeviceCode = doReady;
    vGlobalCode = doReady;

	CodesSame = 1;

    for (i = 0; i < apCodeList->mCount; i++)
    {
        // noop if doReady
        if (apCodeList->mNextCodes[i] == doReady)
            apCodeList->mExecutedCodes[i] = doNoOp;
		
        // code to execute
        else
        {
            // 
			if((vPreviousDeviceCode != doReady) &&
			   (vPreviousDeviceCode != apCodeList->mNextCodes[i]))
			   CodesSame = 0;
			else {
               apCodeList->mExecutedCodes[i] = apCodeList->mNextCodes[i];
               vPreviousDeviceCode = apCodeList->mNextCodes[i];
			   vGlobalCode = apCodeList->mExecutedCodes[i];
			}
        }
    }

	if(CodesSame)
	{
        return vGlobalCode;
	}
	else 
	{
		PreferCodeFound = 0;

        while(!PreferCodeFound)
		{
	        vNextGlobalCode = GetPreferGlobalCode(vPastGlobalCode);

			for (i = 0; i < apCodeList->mCount; i++)
			{
                // noop if doReady
                if (apCodeList->mNextCodes[i] == doReady)
                    apCodeList->mExecutedCodes[i] = doNoOp;
                // code to execute
                else
				{
                 // 

			       if(apCodeList->mNextCodes[i] == vNextGlobalCode)
				   {
			           PreferCodeFound = 1;
                       apCodeList->mExecutedCodes[i] = apCodeList->mNextCodes[i];
				   }
			       else 
				   {
                      apCodeList->mExecutedCodes[i] = doNoOp;
					
				   } //else
				} // esle
			}//For

			vPastGlobalCode = vNextGlobalCode;
        } // while

		return vNextGlobalCode;
	} // else
} // end getGlobalCode	

/* -------------------------------------------------------------------------- */
/* --- checks the PastCode and gets the next prefered global code     --- */
/* -------------------------------------------------------------------------- */
tCode GetPreferGlobalCode(tCode PastCode)
{

    tCode PreferedNextCode = doReady;

	if(PastCode == doReady)
		PreferedNextCode = doIrScan;

	else if(PastCode == doIrScan)
		    PreferedNextCode = doDrScanIn;

	else if(PastCode == doDrScanIn )
		    PreferedNextCode = doWait;

	else if(PastCode == doWait)
		    PreferedNextCode = doDrScanOut;

	else if(PastCode == doDrScanOut)
		    PreferedNextCode = doIrScan;

    return PreferedNextCode;
}
/******************************************************************************/
/***** lokal, device specific codes                                       *****/
/******************************************************************************/

/* -------------------------------------------------------------------------- */
/* --- init arrays for device specific codes (next and to execute)        --- */
/* -------------------------------------------------------------------------- */
pCodeList InitCodeList(int aDeviceCount)
{
    int i;
    pCodeList vpCodeList;

    // abort, if device count > max device count
    if (aDeviceCount > MaxDeviceCount)
    {
        WRITEError("\n...Error - Device count(%d) > max device count(%d).\n",
            aDeviceCount, MaxDeviceCount);
        return NULL;
    }
    // init code list
    vpCodeList = (pCodeList)GETMem(sizeof(tCodeList));
    FILLChar(vpCodeList, 0, sizeof(tCodeList));
    // doReady for all devices
    vpCodeList->mCount = aDeviceCount;
    for (i = 0; i < vpCodeList->mCount; i++)
        vpCodeList->mExecutedCodes[i] = doReady;
/* Frank Phillips @ Xilinx Added the following two lines on
May_01_2001 */
        vpCodeList->mIscEnableCodes[i] = doReady;
        vpCodeList->mIscDisableCodes[i] = doReady;
    return vpCodeList;
}

/* -------------------------------------------------------------------------- */
/* --- Release CodeList                                                   --- */
/* -------------------------------------------------------------------------- */
int DoneCodeList(pCodeList apCodeList)
{
        FREEMem(apCodeList, sizeof(tCodeList));
}

/* -------------------------------------------------------------------------- */
/* --- init code loop for device (go to first code of action)             --- */
/* -------------------------------------------------------------------------- */
int InitCodeLoop(pDevEnt apDevice, int *vActionCount)
{
    // get action
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    vpStatus->mAction = GetActionByName(apDevice,
        &ACTIONNameOfDevice(apDevice), &DATANameOfDevice(apDevice));

    // init action status
/* Frank Phillips @Xilinx added Enable and Disable Instructions on
May_01_2001 */
    // bypass, enable, disable instructions
    GetBypassInstructionCodeOfDevice(apDevice, &vpStatus->mBypassInstruction);
    GetEnableInstructionCodeOfDevice(apDevice, &vpStatus->mEnableInstruction);
    GetDisableInstructionCodeOfDevice(apDevice, &vpStatus->mDisableInstruction);
    // none action option in command file
    if (STRChEqualNoCase(ACTIONNameOfDevice(apDevice), ""))
    {
        WRITEStatus("\n  ...device %s: no action", STRPChar(DEVICEName(apDevice)));
        vpStatus->mProgram = 0;
        vpStatus->mResult = resNoAction;
        return rtOk;
    }
    // action to execute
    if (vpStatus->mAction != NULL)
    {
        WRITEStatus("\n  ...device %s: action %s (%s)", STRPChar(DEVICEName(apDevice)),
            STRPChar(ACTIONNameOfDevice(apDevice)),
            STRPChar(DATANameOfDevice(apDevice)));

        vpStatus->mProgram = 1;
        vpStatus->mResult = resFail;
        vpStatus->mProcedureIndex = -1;
        if (InitNextProcedure(apDevice))
            return rtErr;
        *vActionCount = *vActionCount + 1;
        return rtOk;
    }
    // action not defined
    WRITEError("\n...Error - device %s: action \"%s (%s)\" isn't defined.\n",
        STRPChar(DEVICEName(apDevice)),
        STRPChar(ACTIONNameOfDevice(apDevice)),
        STRPChar(DATANameOfDevice(apDevice)));
    return rtErr;
}

/* -------------------------------------------------------------------------- */
/* --- get next code for device (only calling if last code != doNoOp)     --- */
/* -------------------------------------------------------------------------- */
tCode GetNextCode(pDevEnt apDevice, int *vError)
{
    // doReady if no action defined
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    if (!vpStatus->mProgram)
		return doReady;


    // loop over all procedures --> flows --> blocks --> block loops
    // --> activities --> codes
    while (vpStatus->mProcedureIndex < vpStatus->mProcedureCount)
    {
        #ifdef DEBUG
            if (LOGDebug)
                if (vpStatus->mWriteProcedureName)
                {
                    WRITEDebug("\nprocedure: %s (%s)", vpStatus->mProcedure->preName.mString,
                        vpStatus->mProcedure->preDataName.mString);
                    vpStatus->mWriteProcedureName = 0;
                }
        #endif
        while (vpStatus->mFlowIndex < vpStatus->mFlowCount)
        {
            #ifdef DEBUG
                if (LOGDebug)
                    if (vpStatus->mWriteFlowName)
                    {
                        WRITEDebug("\n  flow: %s (%s)", vpStatus->mFlow->ifeFlowName.mString,
                            vpStatus->mFlow->ifeDataName.mString);
                        vpStatus->mWriteFlowName = 0;
                    }
            #endif
            while (vpStatus->mBlockIndex < 3)
            {
                #ifdef DEBUG
                    if (LOGDebug)
                        if (vpStatus->mWriteBlockId)
                        {
                            if (vpStatus->mBlockIndex == 0)
                                WRITEDebug("\n    INITIALIZE");
                            if (vpStatus->mBlockIndex == 1)
                                WRITEDebug("\n    REPEAT");
                            if (vpStatus->mBlockIndex == 2)
                                WRITEDebug("\n    TERMINATE");
                            vpStatus->mWriteBlockId = 0;
                        }
                #endif
                while (vpStatus->mBlockLoopIndex < vpStatus->mBlockLoopCount)
                {
                    #ifdef DEBUG
                        if (LOGDebug)
                        {
                            if ((vpStatus->mBlockIndex == 1) && (vpStatus->mWriteBlockLoopIndex))
                                WRITEDebug("\n    loop: %d", (vpStatus->mBlockLoopIndex + 1));
                            vpStatus->mWriteBlockLoopIndex = 0;
                        }
                    #endif

                    // return code
                    while (vpStatus->mActivityIndex < vpStatus->mActivityCount)
                    {
                        vpStatus->mCodeIndex++;
                        // ir scan
                        if (vpStatus->mCodeIndex == 0)
                        {
                            #ifdef DEBUG
                                if (LOGDebug)
                                    WRITEDebug("\n      activity:\n        --> (irScan - %s)",
                                        STRPChar(INSTRUCTIONNameOfActivity(vpStatus->mActivity)));
                            #endif
                            return doIrScan;
                        }
                        // dr scan in
                        if (vpStatus->mCodeIndex == 1)
                        {
                            // optional
                            if (UPDATEFieldSumOfActivity(vpStatus->mActivity) > 0)
                            {
                                #ifdef DEBUG
                                    if (LOGDebug)
                                        WRITEDebug("\n        --> (drScanIn)");
                                #endif
                                return doDrScanIn;
                            }
                            // go to wait
                            vpStatus->mCodeIndex++;
                        }
                        // wait
                        if (vpStatus->mCodeIndex == 2)
                        {
                            #ifdef DEBUG
                                if (LOGDebug)
                                    WRITEDebug("\n        --> (wait)");
                            #endif
                            return doWait;
                        }
                        // dr scan out
                        if (vpStatus->mCodeIndex == 3)
                        {
                            // optional
                            if (CAPTUREFieldSumOfActivity(vpStatus->mActivity) > 0)
                            {
                                #ifdef DEBUG
                                    if (LOGDebug)
                                    {
                                        WRITEDebug("\n        --> (drScanOut)");
                                        vpStatus->mWriteUFValueType = 1;
                                    }
                                #endif
                                vpStatus->mDoneUpdateFieldValue = 1;
                                vpStatus->mUpdateFieldIndex = -1;
                                InitNextUpdateField(apDevice);
                                return doDrScanOut;
                            }
                            // go to next activity
                            vpStatus->mCodeIndex++;
                        }
                        if (InitNextActivity(apDevice))
                        {
                            *vError = rtErr;
                            return 0;
                        }
                    }   // end activity loop
                    if (IncBlockLoop(apDevice))
                    {
                        *vError = rtErr;
                        return 0;
                    }
                }   // end block repeat loop
                if (InitNextBlock(apDevice))
                {
                    *vError = rtErr;
                    return 0;
                }
            }   // end block loop
            if (InitNextFlow(apDevice))
            {
                *vError = rtErr;
                return 0;
            }
        }   // end flow loop
        // abort if last procedure == proc_error_exit
        if (vpStatus->mError)
            return doReady;
        // . else continue with next procedure in the action
        if (InitNextProcedure(apDevice))
        {
            *vError = rtErr;
            return 0;
        }
    }   // end procedure loop

    // action successfully processed
    WRITEStatus("\n  ...device %s: action %s (%s) processed.",
        STRPChar(DEVICEName(apDevice)),
        STRPChar(vpStatus->mAction->aceName),
        STRPChar(vpStatus->mAction->aceDataName));
    if (vpStatus->mResult != resIgnoreFail)
        vpStatus->mResult = resPass;
    return doReady;
}

/******************************************************************************/
/***** parameter functions                                                *****/
/******************************************************************************/

/* -------------------------------------------------------------------------- */
/* --- init parameters for current activity (in code loop)                --- */
/* -------------------------------------------------------------------------- */
int InitActivityParameters(pDevEnt apDevice)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    // ir scan parameters
    vpStatus->mInstruction
        = INSTRUCTIONCodeOfActivity(vpStatus->mActivity);
    vpStatus->mInstructionBitIndex = STRLen(vpStatus->mInstruction) - 1;

    // dr scan parameters
    vpStatus->mDoneUpdateFieldValue
        = CAPTUREFieldSumOfActivity(vpStatus->mActivity) == 0;
    if (InitFieldValues(apDevice))
        return rtErr;
    vpStatus->mUpdateFieldIndex = -1;
    if (InitNextUpdateField(apDevice))
        return rtErr;
    vpStatus->mCaptureFieldIndex = -1;
    if (InitNextCaptureField(apDevice))
        return rtErr;

    // wait parameters
    vpStatus->mWaitMin = WAITMinStmtOfActivity(vpStatus->mActivity);
    return rtOk;
}
/* -------------------------------------------------------------------------- */
/* ------------------       Pick the longest wait time   -------------------- */
/* -------------------------------------------------------------------------- */
int PickLongestWait(pProg1532 aProg1532, pExecutor aExecutor, int vDeviceCount, int *vError)
{
	int i;
    pDevEnt vpDevice;
    pActionStatus vpStatus;
    double Cycle2TimeFactor, vCurrentCycleTime, vCurrentWaitTime,
		  MaxCycleTime, MaxWaitTime;

		Cycle2TimeFactor = 0.000001;
		MaxCycleTime = 0.0;
		MaxWaitTime  = 0.0;
		for (i = 0; i < vDeviceCount; i++)
        {
	        vCurrentCycleTime = 0;
			vCurrentWaitTime = 0;
	        vpDevice = GetDeviceAtIndex(aProg1532, i);
            vpStatus = ACTIONStatusOfDevice(vpDevice);
			if(vpStatus->mWaitMin != NULL) {
			   vCurrentCycleTime = vpStatus->mWaitMin->mCycleCount * Cycle2TimeFactor;
		       vCurrentWaitTime  = vpStatus->mWaitMin->mTime;

               if(vCurrentCycleTime > MaxCycleTime)
			      MaxCycleTime = vCurrentCycleTime;

               if(vCurrentWaitTime > MaxWaitTime)
			      MaxWaitTime = vCurrentWaitTime;
			}
		} 
        
		if ((MaxCycleTime == 0.0) && (MaxWaitTime == 0.0))
			*vError = 1;
        else
		{
			*vError = 0;
			if(MaxWaitTime >= MaxCycleTime)
			{
				aExecutor->mWaitTime = MaxWaitTime;
				aExecutor->mWaitCycleCount = 0;
			}
			else
			{
				aExecutor->mWaitTime = 0.0;
				aExecutor->mWaitCycleCount = MaxCycleTime/Cycle2TimeFactor;
			}

		}

        #ifdef DEBUG
            if (LOGDebug)
                WRITEDebug(" (tFP: %f, cc: %d)", aExecutor->mWaitTime,
                    aExecutor->mWaitCycleCount);
        #endif
}

/* -------------------------------------------------------------------------- */
/* --- get next parameter for current activity (depended on current code) --- */
/* -------------------------------------------------------------------------- */
int GetNextParameter(pExecutor aExecutor, pDevEnt apDevice, int *vError)
{
    tByte vTCKClockInfo;
    pActionStatus vpStatus;
    char *vInstruction;
    int vAddTDOByte;

    #ifdef DEBUG
        TSTRING vTDOBits;
        TSTRING vExpectBits;
        TSTRING vMaskBits;
        if (LOGDebug)
        {
            STRInit(vTDOBits, "");
            STRInit(vExpectBits, "");
            STRInit(vMaskBits, "");
        }
    #endif

    vpStatus = ACTIONStatusOfDevice(apDevice);
    // ir scan (TDO)
    if (vpStatus->mCodeIndex == 0)
    {
        #ifdef DEBUG
            if (LOGDebug)
                WRITEDebug(" (code:");
        #endif

        // loop over all bits of instruction opcode (from right to left)
        vInstruction = STRPChar(vpStatus->mInstruction);
        while (vpStatus->mInstructionBitIndex >= 0)
        {
            // set bit in info byte
            vTCKClockInfo = 0x00;
            if (vInstruction[vpStatus->mInstructionBitIndex] == '1')
            {
                SetTCKClockInfoBit(&vTCKClockInfo, bitTDO);
                #ifdef DEBUG
                    if (LOGDebug)
                        STRAddChar(vTDOBits, '1');
                #endif
            }
            else
            {
                #ifdef DEBUG
                    if (LOGDebug)
                        STRAddChar(vTDOBits, '0');
                #endif
            }
            // . and add the byte to tdo buffer of executor
            if (! AddTCKClockInfoTDO(aExecutor, &vTCKClockInfo))
                vpStatus->mInstructionBitIndex--;
            else
            {
                #ifdef DEBUG
                    if (LOGDebug)
                    {
                        STRRemoveLastChar(vTDOBits);
                        WriteStringBitField(&vTDOBits);
                        STRDone(vTDOBits);
                    }
                #endif
                // buffer overflow --> get remaining bits in next call
                return 0;
            }
        }
        #ifdef DEBUG
            if (LOGDebug)
            {
                WriteStringBitField(&vTDOBits);
                STRDone(vTDOBits);
                WRITEDebug(")");
            }
        #endif
        // all bits delivered
        return 1;
    }
    // dr scan in (TDO)
    if (vpStatus->mCodeIndex == 1)
    {
        // loop over all update fields of current activity (from right to left)
        while (vpStatus->mUpdateFieldIndex >= 0)
        {
            #ifdef DEBUG
                if (LOGDebug)
                    if (vpStatus->mWriteUFValueType)
                    {
                        WRITEDebug("%s", STRPChar(vpStatus->mUFValueType));
                        vpStatus->mWriteUFValueType = 0;
                        WRITEDebug(" (");
                    }
            #endif
            // field bits from right to left
            while (vpStatus->mUFBitIndex < vpStatus->mUFBitCount)
            {
                // add empty byte to tdi buffer
                vTCKClockInfo = 0x00;
                AddTCKClockInfoTDI(aExecutor, &vTCKClockInfo);

                // set bit in info byte
                vTCKClockInfo = 0x00;
                if (BitAtIndex(&(vpStatus->mUFValue), vpStatus->mUFBitIndex))
                {
                    SetTCKClockInfoBit(&vTCKClockInfo, bitTDO);
                    #ifdef DEBUG
                        if (LOGDebug)
                            STRAddChar(vTDOBits, '1');
                    #endif
                }
                else
                {
                    #ifdef DEBUG
                        if (LOGDebug)
                            STRAddChar(vTDOBits, '0');
                    #endif
                }
                // . and add the byte to tdo buffer of executor
                if (! AddTCKClockInfoTDO(aExecutor, &vTCKClockInfo))
                {
                    vpStatus->mUFBitIndex++;
                }
                else
                {
                    #ifdef DEBUG
                        if (LOGDebug)
                        {
                            STRRemoveLastChar(vTDOBits);
                            WriteStringBitField(&vTDOBits);
                            STRDone(vTDOBits);
                        }
                    #endif
                    // buffer overflow --> get remaining bits in next call
                    return 0;
                }

            }   // end bit loop
            if (InitNextUpdateField(apDevice))
            {
                *vError = rtErr;
                return 1;
            }
            #ifdef DEBUG
                if (LOGDebug)
                    if (vpStatus->mUpdateFieldIndex >= 0)
                        STRAddChar(vTDOBits, ':');
            #endif
        }   // end field loop
        #ifdef DEBUG
            if (LOGDebug)
            {
                WriteStringBitField(&vTDOBits);
                STRDone(vTDOBits);
                WRITEDebug(")");
            }
        #endif
        // all bits delivered
        return 1;
    }
    // wait
    if (vpStatus->mCodeIndex == 2)
    {
        aExecutor->mWaitTime = vpStatus->mWaitMin->mTime;
        aExecutor->mWaitCycleCount = vpStatus->mWaitMin->mCycleCount;
        #ifdef DEBUG
            if (LOGDebug)
                WRITEDebug(" (t: %f, cc: %d)", aExecutor->mWaitTime,
                    aExecutor->mWaitCycleCount);
        #endif
        return 1;
    }
    // dr scan out (TDO, TDI expected and mask)
    if (vpStatus->mCodeIndex == 3)
    {
        // TDO
        vAddTDOByte = 1;
        // loop over all update fields of current activity (from right to left)
        while ((vpStatus->mUpdateFieldIndex >= 0) && vAddTDOByte)
        {
            #ifdef DEBUG
                if (LOGDebug)
                    if (vpStatus->mWriteUFValueType)
                    {
                        WRITEDebug("%s", STRPChar(vpStatus->mUFValueType));
                        vpStatus->mWriteUFValueType = 0;
                    }
            #endif
            // field bits from right to left
            while ((vpStatus->mUFBitIndex < vpStatus->mUFBitCount) && vAddTDOByte)
            {
                // set bit in info byte
                vTCKClockInfo = 0x00;
                if (BitAtIndex(&(vpStatus->mUFValue), vpStatus->mUFBitIndex))
                {
                    SetTCKClockInfoBit(&vTCKClockInfo, bitTDO);
                    #ifdef DEBUG
                        if (LOGDebug)
                            STRAddChar(vTDOBits, '1');
                    #endif
                }
                else
                {
                    #ifdef DEBUG
                        if (LOGDebug)
                            STRAddChar(vTDOBits, '0');
                    #endif
                }
                // . and add the byte to tdo buffer of executor
                if (! AddTCKClockInfoTDO(aExecutor, &vTCKClockInfo))
                {
                    vpStatus->mUFBitIndex++;
                }
                else
                    // buffer overflow --> get remaining bits in next call
                    vAddTDOByte = 0;

            }   // end bit loop
            if (vAddTDOByte)
                if (InitNextUpdateField(apDevice))
                {
                    *vError = rtErr;
                    return 1;
                }
            #ifdef DEBUG
                if (LOGDebug)
                    if (vpStatus->mUpdateFieldIndex >= 0)
                        STRAddChar(vTDOBits, ':');
            #endif
        }   // end update field loop
        // TDI expected and mask
        // loop over all capture fields of current activity (from right to left)
        while (vpStatus->mCaptureFieldIndex >= 0)
        {
            #ifdef DEBUG
                if (LOGDebug)
                    if (vpStatus->mWriteCFValueType)
                    {
                        WRITEDebug("%s", STRPChar(vpStatus->mCFValueType));
                        WRITEDebug("%s", STRPChar(vpStatus->mMaskValueType));
                        vpStatus->mWriteCFValueType = 0;
                    }
            #endif
            // field bits from right to left
            while (vpStatus->mCFBitIndex < vpStatus->mCFBitCount)
            {
                // add empty byte to tdo buffer, if no update field list given
                vTCKClockInfo = 0x00;
                if (UPDATEFieldSumOfActivity(vpStatus->mActivity) == 0)
                {
                    AddTCKClockInfoTDO(aExecutor, &vTCKClockInfo);
                    #ifdef DEBUG
                        if (LOGDebug)
                            STRAddChar(vTDOBits, 'x');
                    #endif
                }
                // set bit in info byte (expect value)
                vTCKClockInfo = 0x00;
                if (BitAtIndex(&(vpStatus->mCFValue), vpStatus->mCFBitIndex))
                {
                    SetTCKClockInfoBit(&vTCKClockInfo, bitTDIExpected);
                    #ifdef DEBUG
                        if (LOGDebug)
                            STRAddChar(vExpectBits, '1');
                    #endif
                }
                else
                {
                    #ifdef DEBUG
                        if (LOGDebug)
                            STRAddChar(vExpectBits, '0');
                    #endif
                }
                // set bit in info byte (mask value)
                if (BitAtIndex(&(vpStatus->mMaskValue), vpStatus->mCFBitIndex))
                {
                    SetTCKClockInfoBit(&vTCKClockInfo, bitTDIMask);
                    #ifdef DEBUG
                        if (LOGDebug)
                            STRAddChar(vMaskBits, '1');
                    #endif
                }
                else
                {
                    #ifdef DEBUG
                        if (LOGDebug)
                            STRAddChar(vMaskBits, '0');
                    #endif
                }
                // . and add the byte to tdi buffer of executor
                if (! AddTCKClockInfoTDI(aExecutor, &vTCKClockInfo))
                {
                        vpStatus->mCFBitIndex++;
                }
                else
                {
                    #ifdef DEBUG
                        if (LOGDebug)
                        {
                            STRRemoveLastChar(vTDOBits);
                            WRITEDebug("\n          tdo:      ");
                            WriteStringBitField(&vTDOBits);
                            STRRemoveLastChar(vExpectBits);
                            WRITEDebug("\n          expected: ");
                            WriteStringBitField(&vExpectBits);
                            STRRemoveLastChar(vMaskBits);
                            WRITEDebug("\n          mask:     ");
                            WriteStringBitField(&vMaskBits);
                            STRDone(vTDOBits);
                            STRDone(vExpectBits);
                            STRDone(vMaskBits);
                        }
                    #endif
                    // buffer overflow --> get remaining bits in next call
                    return 0;
                }
            }   // end bit loop
            if (InitNextCaptureField(apDevice))
            {
                *vError = rtErr;
                return 1;
            }
            #ifdef DEBUG
                if (LOGDebug)
                    if (vpStatus->mCaptureFieldIndex >= 0)
                    {
                        STRAddChar(vExpectBits, ':');
                        STRAddChar(vMaskBits, ':');
                    }
            #endif
        }   // end capture field loop
        #ifdef DEBUG
            if (LOGDebug)
            {
                WRITEDebug("\n          tdo:      ");
                WriteStringBitField(&vTDOBits);
                WRITEDebug("\n          expected: ");
                WriteStringBitField(&vExpectBits);
                WRITEDebug("\n          mask:     ");
                WriteStringBitField(&vMaskBits);
                STRDone(vTDOBits);
                STRDone(vExpectBits);
                STRDone(vMaskBits);
            }
        #endif
        // all bits delivered
        return 1;
    }
    *vError = rtErr;
    return 1;
}
/* -------------------------------------------------------------------------- */
/* --- get next parameter for a forced scanout --- */
/* -------------------------------------------------------------------------- */

int GetNextForcedScanout(pExecutor aExecutor, pDevEnt apDevice, tCode vGlobalCode, int *vError)
{
    tByte vTCKClockInfo;
    pActionStatus vpStatus;
    char *vInstruction;
    int vAddTDOByte, i, RegLenPdata, PdataRegFound, BitIndex;
 

	tList RegList;
	pDataRegEnt DataReg0;
	
 
    #ifdef DEBUG
        TSTRING vTDOBits;
        TSTRING vExpectBits;
        TSTRING vMaskBits;
        if (LOGDebug)
        {
            STRInit(vTDOBits, "");
            STRInit(vExpectBits, "");
            STRInit(vMaskBits, "");
        }
    #endif

    vpStatus = ACTIONStatusOfDevice(apDevice);

    RegList = apDevice ->dveBsdlInfo->bsdDataRegList ;
    
	PdataRegFound = 0;

    for (i = 0; i < RegList.Count; i++)
	{

	   DataReg0 = RegList.items[i];
	   if(!strcmp(DataReg0->mDataRegName.mString, "ISC_PDATA"))
	   {
	      RegLenPdata = DataReg0->mLength ;
	      PdataRegFound = 1;
	   }

	}

	if(PdataRegFound == 0) 
	{
	   printf("Error :  ISC_PDATA not found in BSDL file \n");
	   *vError = rtErr;
       return 1;
	}
	
	// dr scan out (TDO, TDI expected and mask)
    if (vGlobalCode == 4)
    {
        // TDO
        vAddTDOByte = 1;
		BitIndex = 0;
        // loop over all update fields of current activity (from right to left)
        while ((BitIndex  < RegLenPdata ) && vAddTDOByte)
        {
		   vTCKClockInfo = 0x00;

		   #ifdef DEBUG
               if (LOGDebug)
                   STRAddChar(vTDOBits, '0');
           #endif
             
          // . and add the byte to tdo buffer of executor
          if (! AddTCKClockInfoTDO(aExecutor, &vTCKClockInfo))
          {
                  BitIndex++;
          }
          else
             // buffer overflow --> get remaining bits in next call
              vAddTDOByte = 0;
		} // end bit loop

        #ifdef DEBUG
             if (LOGDebug)
                  STRAddChar(vTDOBits, ':');
        #endif



	    // TDI expected and mask

        vAddTDOByte = 1;
		BitIndex = 0;

	    while (BitIndex  < RegLenPdata)
        {
		   vTCKClockInfo = 0x00;


           #ifdef DEBUG
               if (LOGDebug)
                   STRAddChar(vExpectBits, '0');
           #endif
        
           #ifdef DEBUG
               if (LOGDebug)
                   STRAddChar(vMaskBits, '0');
           #endif

           // . and add the byte to tdi buffer of executor
           if (! AddTCKClockInfoTDI(aExecutor, &vTCKClockInfo))
		   {
              BitIndex++;
		   }
           else
           {
            #ifdef DEBUG
               
                        if (LOGDebug)
                        {
                            STRRemoveLastChar(vTDOBits);
                            WRITEDebug("\n          tdo:      ");
                            WriteStringBitField(&vTDOBits);
                            STRRemoveLastChar(vExpectBits);
                            WRITEDebug("\n          expected: ");
                            WriteStringBitField(&vExpectBits);
                            STRRemoveLastChar(vMaskBits);
                            WRITEDebug("\n          mask:     ");
                            WriteStringBitField(&vMaskBits);
                            STRDone(vTDOBits);
                            STRDone(vExpectBits);
                            STRDone(vMaskBits);
                        }
                    #endif
                    // buffer overflow --> get remaining bits in next call
                    return 0;
                }
            }   // end bit loop

            #ifdef DEBUG
                if (LOGDebug)
                    
                    {
                        STRAddChar(vExpectBits, ':');
                        STRAddChar(vMaskBits, ':');
                    }
            #endif
  
        #ifdef DEBUG
            if (LOGDebug)
            {
                WRITEDebug("\n          tdo:      ");
                WriteStringBitField(&vTDOBits);
                WRITEDebug("\n          expected: ");
                WriteStringBitField(&vExpectBits);
                WRITEDebug("\n          mask:     ");
                WriteStringBitField(&vMaskBits);
                STRDone(vTDOBits);
                STRDone(vExpectBits);
                STRDone(vMaskBits);
            }
        #endif
        // all bits delivered
        return 1;
		
    } // end while vGlobalCode == 4
    *vError = rtErr;
    return 1;
}

/* -------------------------------------------------------------------------- */
/* --- init bypass parameter (reset indixes)                              --- */
/* -------------------------------------------------------------------------- */
int InitBypassParameter(pDevEnt apDevice)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);

    vpStatus->mBypassInstructionBitIndex
        = STRLen(vpStatus->mBypassInstruction) - 1;
    vpStatus->mBypassParameterBit = 1;
    return rtOk;
}

/* -------------------------------------------------------------------------- */
/* --- get bypass parameter depended on current code                      --- */
/* -------------------------------------------------------------------------- */
int GetBypassParameter(pExecutor aExecutor, pDevEnt apDevice, tCode vCode,
    int *vError)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    tTCKClockInfo vTCKClockInfo;
    char *vInstruction = STRPChar(vpStatus->mBypassInstruction);

    #ifdef DEBUG
        TSTRING vBypassBits;
        if (LOGDebug)
            STRInit(vBypassBits, "");
    #endif

    // ir scan --> bypass code for device
    if (vCode == doIrScan)
    {
        #ifdef DEBUG
            if (LOGDebug)
                WRITEDebug(" (code - bypass:");
        #endif
        // loop over all bits of bypass instruction opcode (from right to left)
        while (vpStatus->mBypassInstructionBitIndex >= 0)
        {
            // set bit in  info byte
            vTCKClockInfo = 0x00;
            if (vInstruction[vpStatus->mBypassInstructionBitIndex] == '1')
            {
                SetTCKClockInfoBit(&vTCKClockInfo, bitTDO);
                #ifdef DEBUG
                    if (LOGDebug)
                        STRAddChar(vBypassBits, '1');
                #endif
            }
            else
            {
                #ifdef DEBUG
                    if (LOGDebug)
                        STRAddChar(vBypassBits, '0');
                #endif
            }
            // . and add the byte to the tdo buffer of executor
            if (! AddTCKClockInfoTDO(aExecutor, &vTCKClockInfo))
            {
                vpStatus->mBypassInstructionBitIndex--;
            }
            else
            {
                #ifdef DEBUG
                    if (LOGDebug)
                    {
                        STRRemoveLastChar(vBypassBits);
                        WriteStringBitField(&vBypassBits);
                        STRDone(vBypassBits);
                    }
                #endif
                // buffer overflow --> get remaining bits in next call
                return 0;
            }
        }
        #ifdef DEBUG
            if (LOGDebug)
            {
                WriteStringBitField(&vBypassBits);
                STRDone(vBypassBits);
                WRITEDebug(")");
            }
        #endif
        // all bits delivered
        return 1;
    }
    // one bit, if dr scan
    if ((vCode == doDrScanIn) || (vCode == doDrScanOut))
    {
        if (vpStatus->mBypassParameterBit)
        {
            // add info byte to tdo and tdi buffer of executor
            vTCKClockInfo = 0x00;
            if (! AddTCKClockInfoTDO(aExecutor, &vTCKClockInfo))
            {
                #ifdef DEBUG
                    if (LOGDebug)
                        WRITEDebug(" (b:bypass)");
                #endif
                vTCKClockInfo = 0x00;
                AddTCKClockInfoTDI(aExecutor, &vTCKClockInfo);
                vpStatus->mBypassParameterBit = 0;
                // bit delivered
                return 1;
            }
            else
                // buffer overflow --> get remaining bits in next call
                return 0;
        }
    }
    // do nothing if wait
    return 1;
}

/******************************************************************************/
/***** update action status                                               *****/
/******************************************************************************/

/* -------------------------------------------------------------------------- */
/* --- init next procedure of action                                      --- */
/* --- (indexes and entities in actionstatus)                             --- */
/* -------------------------------------------------------------------------- */
int InitNextProcedure(pDevEnt apDevice)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    pActProcEnt vActionProc;
    pList vProcedureList = PROCEDUREListOfAction(vpStatus->mAction);

    #ifdef DEBUG
        if (LOGDebug)
            vpStatus->mWriteProcedureName = 1;
    #endif

    // next procedure
    if (vProcedureList != NULL)
    {
        vpStatus->mProcedureCount = ITEMCountOfList(vProcedureList);
        vpStatus->mProcedureIndex++;
        vActionProc
            = (pActProcEnt) GetItemAtIndex(vProcedureList, vpStatus->mProcedureIndex);

        // cascade: --> first flow of procedure --> first block  --> first loop
        // --> first activity --> activity parameters
        if (vActionProc != NULL)
        {
            vpStatus->mProcedure = GETActionProc(vActionProc);
            if (vpStatus->mProcedure != NULL)
            {
                WRITEStatus("\n    ...device %s: procedure %s (%s)",
                    STRPChar(DEVICEName(apDevice)),
                    STRPChar(vpStatus->mProcedure->preName),
          STRPChar(vpStatus->mProcedure->preDataName));

                vpStatus->mFlowIndex = -1;
                return InitNextFlow(apDevice);
            }
        }
        return rtOk;
    }
    WRITEError("\n...Error - procedure list is empty.\n");
    return rtErr;
}

/* -------------------------------------------------------------------------- */
/* --- init procedure for error exit                                      --- */
/* --- (indexes and entities in actionstatus)                             --- */
/* -------------------------------------------------------------------------- */
int InitErrorProcedure(pDevEnt apDevice)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    pProcEnt vpProcedure;
    TSTRING vProcName;

    // return, if already init
    if ((! vpStatus->mProgram) || vpStatus->mError)
        return rtOk;

    STRInit(vProcName, "proc_error_exit");
    vpProcedure = GetProcedureByName(apDevice, &vProcName);

    #ifdef DEBUG
        if (LOGDebug)
            vpStatus->mWriteProcedureName = 1;
    #endif
    vpStatus->mProgram = 0;
    vpStatus->mError = 1;

    if (vpProcedure != NULL)
    {
        WRITEError("\n    ...device %s: proc_error_exit",
            STRPChar(apDevice->dveName));

        vpStatus->mProcedure = vpProcedure;
        vpStatus->mProcedureCount = 1;
        vpStatus->mProcedureIndex = 0;
        vpStatus->mProgram = 1;

        // cascade: --> first flow of procedure --> first block  --> first loop
        // --> first activity --> activity parameters
        vpStatus->mFlowIndex = -1;
        return InitNextFlow(apDevice);
    }
    return rtOk;
}

/* -------------------------------------------------------------------------- */
/* --- init next flow of current procedure                                --- */
/* --- (indexes and entities in actionstatus)                             --- */
/* -------------------------------------------------------------------------- */
int InitNextFlow(pDevEnt apDevice)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    pList vFlowList = FLOWListOfProcedure(vpStatus->mProcedure);

    #ifdef DEBUG
        if (LOGDebug)
            vpStatus->mWriteFlowName = 1;
    #endif
    // next flow
    if (vFlowList != NULL)
    {
        vpStatus->mFlowCount = ITEMCountOfList(vFlowList);
        vpStatus->mFlowIndex++;
        vpStatus->mFlow
            = (pIscFlowEnt) GetItemAtIndex(vFlowList, vpStatus->mFlowIndex);

        // cascade: --> first block of flow --> first loop
        // --> first activity --> activity parameters
        if (vpStatus->mFlow != NULL)
        {
            vpStatus->mBlockIndex = -1;
            return InitNextBlock(apDevice);
        }
        return rtOk;
    }
    WRITEError("\n...Error - flow list is empty.\n");
    return rtErr;
}

/* -------------------------------------------------------------------------- */
/* --- init next block of current flow                                    --- */
/* --- (indexes and entities in actionstatus)                             --- */
/* -------------------------------------------------------------------------- */
int InitNextBlock(pDevEnt apDevice)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    pDataRecord vDataRecord;

    #ifdef DEBUG
        if (LOGDebug)
            vpStatus->mWriteBlockId = 1;
    #endif

    // next block
    vpStatus->mBlock = NULL;
    while((vpStatus->mBlock == NULL) && (vpStatus->mBlockIndex < 3))
    {
        vpStatus->mBlockIndex++;
        vpStatus->mBlock    = GetBlockAtIndex(vpStatus->mFlow, vpStatus->mBlockIndex);
    }

    if (vpStatus->mBlock != NULL)
    {
        // first loop
        vpStatus->mBlockLoopCount = LOOPCountOfBlock(vpStatus->mBlock);
        if (vpStatus->mBlockLoopCount == 0)
            vpStatus->mBlockLoopCount = 1;
        vpStatus->mBlockLoopIndex = 0;

        // get file position for data block
        vDataRecord
            = GetDataRecordByName(vpStatus, &(vpStatus->mFlow->ifeDataName));
        if (vDataRecord != NULL)
        {
            switch (vpStatus->mBlockIndex)
            {
                case 0:
                    vpStatus->mCurrentFilePos = vDataRecord->mInitBlockPos;
                    SETFilePos1532DataFile(vpStatus->mDataInputFile,
                        vpStatus->mCurrentFilePos);
                //  SETFilePos(vpStatus->mDataInputFile, vDataRecord->mInitBlockPos);
                    break;
                case 1:
                    vpStatus->mCurrentFilePos = vDataRecord->mRepeatBlockPos;
                    SETFilePos1532DataFile(vpStatus->mDataInputFile,
                        vpStatus->mCurrentFilePos);
                 // SETFilePos(vpStatus->mDataInputFile, vDataRecord->mRepeatBlockPos);
                    break;
                case 2:
                    vpStatus->mCurrentFilePos = vDataRecord->mTerminateBlockPos;
                    SETFilePos1532DataFile(vpStatus->mDataInputFile,
                        vpStatus->mCurrentFilePos);
                //  SETFilePos(vpStatus->mDataInputFile, vDataRecord->mTerminateBlockPos);
                    break;
            }
        }
        // cascade: --> first activity --> activity parameters
        vpStatus->mActivityIndex = -1;
        return InitNextActivity(apDevice);
    }
    return rtOk;
}

/* -------------------------------------------------------------------------- */
/* --- increment block loop (for repeat block of current flow)            --- */
/* -------------------------------------------------------------------------- */
int IncBlockLoop(pDevEnt apDevice)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);

    #ifdef DEBUG
        if (LOGDebug)
            vpStatus->mWriteBlockLoopIndex = 1;
    #endif

    vpStatus->mBlockLoopIndex++;
    if (vpStatus->mBlockLoopIndex < vpStatus->mBlockLoopCount)
    {
        // break repeat block if block end reached
        if (vpStatus->mBlockEnd)
        {
            vpStatus->mBlockLoopIndex = vpStatus->mBlockLoopCount;
            return rtOk;
        }

        // cascade: --> first activity --> activity parameters
        vpStatus->mActivityIndex = -1;
        vpStatus->mBlockEnd = 0;
        return (InitNextActivity(apDevice));
    }
    return rtOk;
}

/* -------------------------------------------------------------------------- */
/* --- init next activity of current block                                --- */
/* --- (indexes and entities in actionstatus)                             --- */
/* -------------------------------------------------------------------------- */
int InitNextActivity(pDevEnt apDevice)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    pList vActivityList = ACTIVITYListOfBlock(vpStatus->mBlock);

    // next activity
    if (vActivityList != NULL)
    {
        vpStatus->mActivityCount = ITEMCountOfList(vActivityList);
        vpStatus->mActivityIndex++;
        vpStatus->mActivity
            = (pFlowActEnt) GetItemAtIndex(vActivityList,   vpStatus->mActivityIndex);

        vpStatus->mCodeIndex = -1;

        // activity parameters
        if (vpStatus->mActivity != NULL)
            if (InitActivityParameters(apDevice))
                return rtErr;

        #ifdef DEBUG
            if (LOGDebug)
                vpStatus->mWriteActivityName = 1;
        #endif
        return rtOk;
    }
    WRITEError("\n...Error - activity list is empty.\n");
    return rtErr;
}

/* -------------------------------------------------------------------------- */
/* --- init next update field of current activity                         --- */
/* --- (indexes and entities in actionstatus)                             --- */
/* -------------------------------------------------------------------------- */
int InitNextUpdateField(pDevEnt apDevice)
{
    // next update field
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    pList vUpdateFieldList = UPDATEFieldListOfActivity(vpStatus->mActivity);
    if (vUpdateFieldList != NULL)
    {
        if (vpStatus->mUpdateFieldIndex == -1)
            vpStatus->mUpdateFieldIndex = ITEMCountOfList(vUpdateFieldList);
        vpStatus->mUpdateFieldIndex--;
        vpStatus->mUpdateField  = (pUpFieldEnt) GetItemAtIndex(vUpdateFieldList,
            vpStatus->mUpdateFieldIndex);

        // field bits
        if (vpStatus->mUpdateField != NULL)
        {
            vpStatus->mUFBitIndex = 0;
            vpStatus->mUFBitCount = vpStatus->mUpdateField->Width;
            vpStatus->mUFValue = vpStatus->mUpdateField->mValue;
            return rtOk;
        }
    }
    return rtOk;
}

/* -------------------------------------------------------------------------- */
/* --- init next capture field of current activity                        --- */
/* --- (indexes and entities in actionstatus)                             --- */
/* -------------------------------------------------------------------------- */
int InitNextCaptureField(pDevEnt apDevice)
{
    // next capture field
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    pList vCaptureFieldList = CAPTUREFieldListOfActivity(vpStatus->mActivity);
    if (vCaptureFieldList != NULL)
    {
        if (vpStatus->mCaptureFieldIndex == -1)
            vpStatus->mCaptureFieldIndex = ITEMCountOfList(vCaptureFieldList);
        vpStatus->mCaptureFieldIndex--;
        vpStatus->mCaptureField = (pCapFieldEnt) GetItemAtIndex(vCaptureFieldList,
            vpStatus->mCaptureFieldIndex);

        // field bits
        if (vpStatus->mCaptureField != NULL)
        {
            vpStatus->mCFBitIndex = 0;
            vpStatus->mCFBitCount = vpStatus->mCaptureField->Width;
            vpStatus->mCFValue = vpStatus->mCaptureField->mValue;
            vpStatus->mMaskValue = vpStatus->mCaptureField->mMaskValue;
            return rtOk;
        }
    }
    return rtOk;
}

/******************************************************************************/
/***** parameter values                                                   *****/
/******************************************************************************/

/* -------------------------------------------------------------------------- */
/* --- compute bit field values for all update and capture fields of the  --- */
/* --- current activity                                                   --- */
/* -------------------------------------------------------------------------- */
int InitFieldValues(pDevEnt apDevice)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    int i;
    pUpFieldEnt vpUpdateField;
    pCapFieldEnt vpCaptureField;
    pList vpUpdateFieldList = UPDATEFieldListOfActivity(vpStatus->mActivity);
    pList vpCaptureFieldList = CAPTUREFieldListOfActivity(vpStatus->mActivity);

    // get update field values as bit fields (from left to right)
    if (vpUpdateFieldList != NULL)
    {
        #ifdef DEBUG
            if (LOGDebug)
            {
                //STRDone(vpStatus->mUFValueType);
                //STRInit(vpStatus->mUFValueType, "(tdo -");
                STRChAssign(vpStatus->mUFValueType, "(tdo -");
                vpStatus->mWriteUFValueType = 1;
            }
        #endif
        for (i = 0; i < ITEMCountOfList(vpUpdateFieldList); i++)
        {
            vpUpdateField = (pUpFieldEnt) GetItemAtIndex(vpUpdateFieldList, i);
          if (vpUpdateField->DataExpr.mOpType != opHexStringConstant)
          {
            if (GetFieldValue(apDevice, vpUpdateField->Width,
                        &vpUpdateField->DataExpr, ftUpdate, &vpUpdateField->mValue))
                return rtErr;
//            vpUpdateField->mValue = vpStatus->mUFValue;
          }
        }
        #ifdef DEBUG
            if (LOGDebug)
                STRAddChar(vpStatus->mUFValueType, ')');
        #endif
    }
    // get capture field values (expected and mask) as bit fields
    // (from left to right)
    if (vpCaptureFieldList != NULL)
    {
        #ifdef DEBUG
            if (LOGDebug)
            {
                //STRDone(vpStatus->mCFValueType);
                //STRDone(vpStatus->mMaskValueType);
                //STRInit(vpStatus->mCFValueType, "(expected -");
                //STRInit(vpStatus->mMaskValueType, "(mask -");
                STRChAssign(vpStatus->mCFValueType, "(expected -");
                STRChAssign(vpStatus->mMaskValueType, "(mask -");
                vpStatus->mWriteCFValueType = 1;
            }
        #endif
        for (i = 0; i < ITEMCountOfList(vpCaptureFieldList); i++)
        {
            vpCaptureField = (pCapFieldEnt) GetItemAtIndex(vpCaptureFieldList, i);
            // expected

          if (vpCaptureField->ExpectData.mOpType != opHexStringConstant)
          {
            if (GetFieldValue(apDevice, vpCaptureField->Width,
                        &vpCaptureField->ExpectData, ftExpected, &vpCaptureField->mValue))
                return rtErr;
//            vpCaptureField->mValue = vpStatus->mCFValue;
          }
            // mask
            if (vpCaptureField->mMask)
            {
              if (vpCaptureField->CompMask.mOpType != opHexStringConstant)
              {
                if (GetFieldValue(apDevice, vpCaptureField->Width,
                        &vpCaptureField->CompMask, ftMask, &vpCaptureField->mValue))
                    return rtErr;
              }
            }
            else
            {
                // default: mask = 11111..1
/*
                InitBitField(&vpStatus->mMaskValue, vpCaptureField->Width);
                ComplementOfBitField(&vpStatus->mMaskValue);
*/
            }
//            vpCaptureField->mMaskValue = vpStatus->mMaskValue;
        }
        #ifdef DEBUG
            if (LOGDebug)
            {
                STRAddChar(vpStatus->mCFValueType, ')');
                STRAddChar(vpStatus->mMaskValueType, ')');
            }
        #endif
    }
    return rtOk;
}

/* -------------------------------------------------------------------------- */
/* --- compute bitfield value for an update or capture field depended on  --- */
/* --- variable value, operand values and operator of data expression     --- */
/* -------------------------------------------------------------------------- */
int GetFieldValue(pDevEnt apDevice, int aFieldWidth, pDataExpr apDataExpr,
    int aFieldType, pBitField aBitField)
{
    pActionStatus vpStatus = ACTIONStatusOfDevice(apDevice);
    pVarEnt vpVariable = apDataExpr->mVarEnt;
    tOpType vOpType = apDataExpr->mOpType;
    TSTRING vHexString = apDataExpr->mHexStringOperand;
    int vInteger = apDataExpr->mIntegerOperand;
    int vReturn=0;

    // hex string (constant or input)
    if (vpVariable == NULL)
    {
        // hex string constant
        if (vOpType == opHexStringConstant)
        {
            #ifdef DEBUG
                if (LOGDebug)
                    switch (aFieldType)
                    {
                        case ftUpdate:
                            STRChConcat(vpStatus->mUFValueType, " hsc");
                            break;
                        case ftExpected:
                            STRChConcat(vpStatus->mCFValueType, " hsc");
                            break;
                        case ftMask:
                            STRChConcat(vpStatus->mMaskValueType, " hsc");
                            break;
                    }
            #endif
 /*           switch (aFieldType)
            {
                case ftUpdate:
                    return HexToBitField(&vpStatus->mUFValue, &vHexString,  aFieldWidth);
                case ftExpected:
                    return HexToBitField(&vpStatus->mCFValue, &vHexString,  aFieldWidth);
                case ftMask:
                    return HexToBitField(&vpStatus->mMaskValue, &vHexString,    aFieldWidth);
            }
*/
            return rtErr;
        }
        // hex string from input data file
        if (vOpType == opInput)
        {
            if (! GetNextInputHexString(vpStatus))
            {
                #ifdef DEBUG
                    if (LOGDebug)
                        switch (aFieldType)
                        {
                            case ftUpdate:
                                STRChConcat(vpStatus->mUFValueType, " inp=");
                                STRConcat(vpStatus->mUFValueType, vpStatus->mInputHexString);
                                break;
                            case ftExpected:
                                STRChConcat(vpStatus->mCFValueType, " inp=");
                                STRConcat(vpStatus->mCFValueType, vpStatus->mInputHexString);
                                break;
                            case ftMask:
                                STRChConcat(vpStatus->mMaskValueType, " inp=");
                                STRConcat(vpStatus->mMaskValueType, vpStatus->mInputHexString);
                                break;
                        }
                #endif
                DoneBitField(aBitField);
                vReturn = HexToBitField(aBitField,&vpStatus->mInputHexString, aFieldWidth);
/*
                switch (aFieldType)
                {
                    case ftUpdate:
                        vReturn = HexToBitField(&vpStatus->mUFValue,
                            &vpStatus->mInputHexString, aFieldWidth);
                        break;
                    case ftExpected:
                        vReturn = HexToBitField(&vpStatus->mCFValue,
                            &vpStatus->mInputHexString, aFieldWidth);
                        break;
                    case ftMask:
                        vReturn = HexToBitField(&vpStatus->mMaskValue,
                            &vpStatus->mInputHexString, aFieldWidth);
                        break;
                }
*/
                STRDone(vpStatus->mInputHexString);
                return vReturn;
            }
        }
        return rtErr;
    }
    // variable assignment
    if (vOpType == opInput)
    {
        if (! GetNextInputHexString(vpStatus))
        {
            #ifdef DEBUG
                if (LOGDebug)
                    switch (aFieldType)
                    {
                        case ftUpdate:
                            STRChConcat(vpStatus->mUFValueType, " var=inp=");
                            STRConcat(vpStatus->mUFValueType, vpStatus->mInputHexString);
                            break;
                        case ftExpected:
                            STRChConcat(vpStatus->mCFValueType, " var=inp=");
                            STRConcat(vpStatus->mCFValueType, vpStatus->mInputHexString);
                            break;
                        case ftMask:
                            STRChConcat(vpStatus->mMaskValueType, " var=inp=");
                            STRConcat(vpStatus->mMaskValueType, vpStatus->mInputHexString);
                            break;
                    }
            #endif
            if (vpVariable->mInit)
            {
                DoneBitField(&vpVariable->varValue);
                 vpVariable->mInit = 0;
            }
            if (! HexToBitField(&vpVariable->varValue, &vpStatus->mInputHexString,
                aFieldWidth))
            {
                   *aBitField = vpVariable->varValue;
/*
                switch (aFieldType)
                {
                    case ftUpdate:
                        vpStatus->mUFValue = vpVariable->varValue;
                        break;
                    case ftExpected:
                        vpStatus->mCFValue = vpVariable->varValue;
                        break;
                    case ftMask:
                        vpStatus->mMaskValue = vpVariable->varValue;
                        break;
                }
*/
                vpVariable->mInit = 1;
                return rtOk;
            }
        }
        return rtErr;
    }
    if (vOpType == opAssignment)
    {
        #ifdef DEBUG
            if (LOGDebug)
                switch (aFieldType)
                {
                    case ftUpdate:
                        STRChConcat(vpStatus->mUFValueType, " var=hsc");
                        break;
                    case ftExpected:
                        STRChConcat(vpStatus->mCFValueType, " var=hsc");
                        break;
                    case ftMask:
                        STRChConcat(vpStatus->mMaskValueType, " var=hsc");
                        break;
                }
        #endif

        if (vpVariable->mInit)
        {
            DoneBitField(&vpVariable->varValue);
            vpVariable->mInit = 0;
         }
        if (! HexToBitField(&vpVariable->varValue, &vHexString, aFieldWidth))
        {
            *aBitField = vpVariable->varValue;
/*            switch (aFieldType)
            {
                case ftUpdate:
                    vpStatus->mUFValue = vpVariable->varValue;
                    break;
                case ftExpected:
                    vpStatus->mCFValue = vpVariable->varValue;
                    break;
                case ftMask:
                    vpStatus->mMaskValue = vpVariable->varValue;
                    break;
            }
*/
            vpVariable->mInit = 1;
            return rtOk;
        }
        return rtErr;
    }
    if (! vpVariable->mInit)
    {
        WRITEError("\n...Error - variable \"%s\" not initialized.\n",
            STRPChar(vpVariable->varName));
        return rtErr;
    }
    // variable (current value)
    if (vOpType == noOp)
    {
        #ifdef DEBUG
            if (LOGDebug)
                switch (aFieldType)
                {
                    case ftUpdate:
                        STRChConcat(vpStatus->mUFValueType, " var");
                        break;
                    case ftExpected:
                        STRChConcat(vpStatus->mCFValueType, " var");
                        break;
                    case ftMask:
                        STRChConcat(vpStatus->mMaskValueType, " var");
                        break;
                }
        #endif
        *aBitField = vpVariable->varValue;
/*
        switch (aFieldType)
        {
            case ftUpdate:
                vpStatus->mUFValue = vpVariable->varValue;
                break;
            case ftExpected:
                vpStatus->mCFValue = vpVariable->varValue;
                break;
            case ftMask:
                vpStatus->mMaskValue = vpVariable->varValue;
                break;
        }
*/
        return rtOk;
    }
    // variable update
    if (! UpdateVariable(vpVariable, vOpType, vInteger))
    {
        #ifdef DEBUG
            if (LOGDebug)
                switch (aFieldType)
                {
                    case ftUpdate:
                        if (vOpType == opComplement)
                            STRChConcat(vpStatus->mUFValueType, " compl");
                        else
                            STRChConcat(vpStatus->mUFValueType, " binOp");
                        break;
                    case ftExpected:
                        if (vOpType == opComplement)
                            STRChConcat(vpStatus->mCFValueType, " compl");
                        else
                            STRChConcat(vpStatus->mCFValueType, " binOp");
                        break;
                    case ftMask:
                        if (vOpType == opComplement)
                            STRChConcat(vpStatus->mMaskValueType, " compl");
                        else
                            STRChConcat(vpStatus->mMaskValueType, " binOp");
                        break;
                }
        #endif
       *aBitField = vpVariable->varValue;
/*
        switch (aFieldType)
        {
            case ftUpdate:
                vpStatus->mUFValue = vpVariable->varValue;
                break;
            case ftExpected:
                vpStatus->mCFValue = vpVariable->varValue;
                break;
            case ftMask:
                vpStatus->mMaskValue = vpVariable->varValue;
                break;
        }
*/
        return rtOk;
    }
    return rtErr;
}

/* -------------------------------------------------------------------------- */
/* --- execute bitfield operations depended on given operator and operand --- */
/* -------------------------------------------------------------------------- */
int UpdateVariable(pVarEnt apVariable, tOpType aOpType, int aOperand)
{
    tBitField vBitField;
    int rt = rtOk;

    if (apVariable != NULL)
    {
        switch (aOpType)
        {
            case opComplement:  // complement
                return ComplementOfBitField(&apVariable->varValue);

            case opPlus:                // addition
                IntToBitField(&vBitField, aOperand, apVariable->varSize);
                rt = AddBitFields(&apVariable->varValue, vBitField);
                DoneBitField(&vBitField);
                return rt;

            case opMinus:               // subtraction
                IntToBitField(&vBitField, aOperand, apVariable->varSize);
                rt = SubBitFields(&apVariable->varValue, vBitField);
                DoneBitField(&vBitField);
                return rt;

            case opShl:                 // shif left
                 return ShiftLeftBitField(&apVariable->varValue, aOperand);
            case opShr:                 // shif right
                return ShiftRightBitField(&apVariable->varValue, aOperand);
            default:                        // wrong update operator
                WRITEError("\n...Error - variable update failed (wrong update operator).\n");
                return rtErr;
        }
    }
    WRITEError("\n...Error - variable update failed.\n");
    return rtErr;
}

/* -------------------------------------------------------------------------- */
/* --- display programming status (if error during programming)           --- */
/* -------------------------------------------------------------------------- */
void WriteProgrammingStatus(pProg1532 apProg1532)
{
    pDevEnt vpDevice;
    pActionStatus vpStatus;
    int i;

    int vDeviceCount = GetDeviceCount(apProg1532);
    for (i = 0; i < vDeviceCount; i++)
    {
        vpDevice = GetDeviceAtIndex(apProg1532, i);
        vpStatus = ACTIONStatusOfDevice(vpDevice);

        // no action
        if (! vpStatus->mProgram)
            continue;

        // status info
        WRITEError("\nstatus of device: %s\n", STRPChar(DEVICEName(vpDevice)));
        WRITEError("  action:      %s (%s)\n", STRPChar(vpStatus->mAction->aceName),
            STRPChar(vpStatus->mAction->aceDataName));
        WRITEError("  procedure:   %s (%s)\n", STRPChar(vpStatus->mProcedure->preName),
            STRPChar(vpStatus->mProcedure->preDataName));
/*
		if (!STRLen(vpStatus->mFlow->ifeFlowName == 0)  &&
					!STRLen(vpStatus->mFlow->ifeFlowName == 0))
*/
        WRITEError("  flow:        %s (%s)\n", STRPChar(vpStatus->mFlow->ifeFlowName),
             STRPChar(vpStatus->mFlow->ifeFlowName));
        WRITEError("  block:       %s\n", STRPChar(vpStatus->mBlock->exbName));
        if (vpStatus->mBlockIndex == 1)
            WRITEError("  loop:        %d\n", (vpStatus->mBlockLoopIndex + 1));
        WRITEError("  activity:    %d\n", (vpStatus->mActivityIndex + 1));
        WRITEError("  instruction: %s\n", STRPChar(vpStatus->mActivity->facInstName));
    }
}

/******************************************************************************/
/***** debug functions                                                    *****/
/******************************************************************************/
#ifdef DEBUG

/* -------------------------------------------------------------------------- */
/* --- write out bitfield                                                 --- */
/* -------------------------------------------------------------------------- */
void WriteStringBitField(PSTRING aBitField)
{
    int i, j;
    TSTRING vBuffer;

    // first in shift order
    for (i = 0; i < STRLen(*aBitField); i++)
    {
        if (STRPChar(*aBitField)[i] != ':')
            WRITEDebug("%c", STRPChar(*aBitField)[i]);
    }

    STRInit(vBuffer, "");
    for (i = STRLen(*aBitField) - 1; i >= 0; i--)
        STRAddChar(vBuffer, STRPChar(*aBitField)[i]);

    // then in field order
    WRITEDebug("  (");
    j = 0;
    for (i = 0; i < STRLen(vBuffer); i++)
    {
        WRITEDebug("%c", STRPChar(vBuffer)[i]);

        if (STRPChar(vBuffer)[i] == ':')
            j = 0;
        else
            j++;

        if (j == 4)
        {
            if (STRPChar(vBuffer)[i] != ':')
                if (i < (STRLen(vBuffer) - 1))
                    if (STRPChar(vBuffer)[i + 1] != ':')
                        WRITEDebug(" ");
            j = 0;
        }
    }
    STRDone(vBuffer);
    WRITEDebug(")");
}

#endif


