/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#ifndef __Interpr__
#define __Interpr__

#include "libenv.h"
#include "logfkt.h"
#include "progty.h"
#include "pdata.h"
#include "executor.h"

/***** constants **************************************************************/
#define MaxDeviceCount 20

#define ftUpdate        0
#define ftExpected  1
#define ftMask          2
// command line options for vector synthesizer
#define vsOptIgnoreFail 0x01
#define vsOptAddClocks  0x02

/***** macros *****************************************************************/
#define NEXTCodes \
    vCodeList->mNextCodes

#define EXECUTEDCodes \
    vCodeList->mExecutedCodes
/* Frank Phillips @ Xilinx Added the following macors to sync concurrent pgmr on
May_01_2001 */

#define IscEnableCodes \
    vCodeList->mIscEnableCodes

#define IscDisableCodes \
    vCodeList->mIscDisableCodes

/***** typ definitions ********************************************************/
typedef struct _tCodeList
{
    int mCount;
    tCode mNextCodes[MaxDeviceCount];
    tCode mExecutedCodes[MaxDeviceCount];
/* Frank Phillips @ Xilinx Added the following lines to enable concur pgmr on
May_01_2001 */
    tCode mIscEnableCodes[MaxDeviceCount];
    tCode mIscDisableCodes[MaxDeviceCount];
} tCodeList, *pCodeList;

typedef struct _tParameter
{
    int mSize;
} tParameter, *pParameter;

typedef struct _tParameterList
{
    int mCount;
    pParameter mParameters[MaxDeviceCount];
} tParameterList, *pParameterList;

/***** function prototypes ****************************************************/
int VectorSynthesizer(pProg1532 aProg1532, int aOptions);
// . global code
tCode GetGlobalCode(pCodeList apCodeList);
//Frank Phillips @Xilinx added 
tCode GetPreferGlobalCode(tCode PastCode);
int GetNextForcedScanout(pExecutor aExecutor, pDevEnt apDevice, tCode vGlobalCode, int *vError);
// . lokal, device specific codes
pCodeList InitCodeList(int aDeviceCount);
int InitCodeLoop(pDevEnt aDevEnt, int *vActionCount);
tCode GetNextCode(pDevEnt aDevEnt, int *vError);
// . parameter functions
int InitActivityParameters(pDevEnt apDevice);
int GetNextParameter(pExecutor aExecutor, pDevEnt aDevEnt, int *vError);
int InitBypassParameter(pDevEnt apDevice);
int GetBypassParameter(pExecutor aExecutor, pDevEnt aDevice, tCode vCode,
    int *vError);
// . update action status
int InitNextProcedure(pDevEnt apDevice);
int InitErrorProcedure(pDevEnt apDevice);
int InitNextFlow(pDevEnt apDevice);
int InitNextBlock(pDevEnt apDevice);
int IncBlockLoop(pDevEnt apDevice);
int InitNextActivity(pDevEnt apDevice);
int InitNextUpdateField(pDevEnt apDevice);
int InitNextCaptureField(pDevEnt apDevice);
// . parameter values
int InitFieldValues(pDevEnt apDevice);
int GetFieldValue(pDevEnt apDevice, int aFieldWidth, pDataExpr apDataExpr,
    int aFieldType);
int UpdateVariable(pVarEnt apVariable, tOpType aOpType, int aOperand);
// . status message
void WriteProgrammingStatus(pProg1532 apProg1532);
// . debug
void WriteStringBitField(PSTRING aBitField);
#endif


