/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#include "logfkt.h"
#include <stdarg.h>

pLog vpLog = NULL;
int vVirtual = 0;

/***** debugging **************************************************************/

/* -------------------------------------------------------------------------- */
void InitLog(void)
{
    vpLog = (pLog) GETMem(sizeof(tLog));
    FILLChar(vpLog, 0 ,sizeof(tLog));

    STRInit(vpLog->mLogFileName, "");
}

/* -------------------------------------------------------------------------- */
void DoneLog(void)
{
    if ( vpLog && vpLog->mLogFile )
    {
        CLOSEFile(vpLog->mLogFile);
    }
}

/* -------------------------------------------------------------------------- */
int SetLogOption(int aOption)
{
    switch (aOption)
    {
        case logFile:
            if (! (vpLog->mOptions & logFile))
                SetLogFile("prog1532.log");
        case logStatus:
    case logDebug:
            vpLog->mOptions |= aOption;
            return rtOk;
        default:
            return rtErr;
    }
}

/* -------------------------------------------------------------------------- */
int IsLogOption(int aOption)
{
    return (vpLog->mOptions & aOption);
}

/* -------------------------------------------------------------------------- */
void SetLogFile(char *aFileName)
{
    if (vpLog->mOptions & logFile)
        CLOSEFile(vpLog->mLogFile);

    vpLog->mOptions |= logFile;
    STRChAssign(vpLog->mLogFileName, aFileName);
    OPENFileW(vpLog->mLogFile, STRPChar(vpLog->mLogFileName));
}

/* -------------------------------------------------------------------------- */
void WriteLog(char *aMsg, ...)
{
    va_list argptr;

    // write to screen if log not initialized
    if (vpLog == NULL)
    {
        va_start (argptr, aMsg);
        VWRITEToScreen(aMsg, argptr);
        va_end(argptr);
        return;
    }

    // write to log file
    if (LOGFile)
    {
        va_start (argptr, aMsg);
        VWRITEToFile(vpLog->mLogFile, aMsg, argptr);
        va_end(argptr);
        return;
    }
    // write to screen if no log file given
    va_start (argptr, aMsg);
    VWRITEToScreen(aMsg, argptr);
    va_end(argptr);
}

/* -------------------------------------------------------------------------- */
void WriteStatusLog(char *aMsg, ...)
{
    va_list argptr;

  // write to screen if log not initialized
    if (vpLog == NULL)
    {
        va_start (argptr, aMsg);
        VWRITEToScreen(aMsg, argptr);
        va_end(argptr);
        return;
    }

    if (LOGStatus)
    {
        // write to file
        if (LOGFile)
        {
            va_start (argptr, aMsg);
            VWRITEToFile(vpLog->mLogFile, aMsg, argptr);
            va_end(argptr);
            return;
        }
        // write to screen if no log file given
        va_start (argptr, aMsg);
        VWRITEToScreen(aMsg, argptr);
        va_end(argptr);
    }
}

/* -------------------------------------------------------------------------- */
void WriteDebugLog(char *aMsg, ...)
{
    va_list argptr;

  // write to screen if log not initialized
    if (vpLog == NULL)
    {
        va_start (argptr, aMsg);
        VWRITEToScreen(aMsg, argptr);
        va_end(argptr);
        return;
    }

    if (LOGDebug)
    {
        // write to file
        if (LOGFile)
        {
            va_start (argptr, aMsg);
            VWRITEToFile(vpLog->mLogFile, aMsg, argptr);
            va_end(argptr);
            return;
        }
    // write to screen if no log file given
        va_start (argptr, aMsg);
        VWRITEToScreen(aMsg, argptr);
        va_end(argptr);
    }
}

/* -------------------------------------------------------------------------- */
void WriteMessageLog(char *aMsg, ...)
{
    va_list argptr;

    // write to screen
    va_start (argptr, aMsg);
    VWRITEToScreen(aMsg, argptr);
    va_end(argptr);

  // write to log file also if one given
    if (vpLog != NULL)
        if (LOGFile)
        {
            va_start (argptr, aMsg);
            VWRITEToFile(vpLog->mLogFile, aMsg, argptr);
            va_end(argptr);
        }
}
/* -------------------------------------------------------------------------- */
void SetVirtual(int aVirtual)
{
    vVirtual = aVirtual;
}
/* -------------------------------------------------------------------------- */
int IsVirtual(void)
{
    return vVirtual;
}


