/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#ifndef __logfkt__
#define __logfkt__

#include "sysopenv.h"
#include "libenv.h"

/***** constants **************************************************************/
#define logFile    0x01
#define logStatus  0x02
#define logDebug   0x04

/***** makros *****************************************************************/
#define WRITE WriteLog
#define WRITEError WriteLog
#define WRITEMessage WriteMessageLog
#define WRITEStatus WriteStatusLog
#define WRITEDebug WriteDebugLog

#define LOGFile \
    IsLogOption(logFile)

#define LOGStatus \
    IsLogOption(logStatus)

#define LOGDebug \
    IsLogOption(logDebug)

#define ISVirtual \
    IsVirtual()

/***** typ definitions ********************************************************/
typedef struct _tLog
{
    int mOptions;
    TSTRING mLogFileName;
    FILE *mLogFile;
  char *mString;
} tLog, *pLog;

/***** function prototypes ****************************************************/
void InitLog(void);
void DoneLog(void);
int SetLogOption(int aOption);
int IsLogOption(int aOption);
void SetLogFile(char *aFileName);
void WriteLog(char *aMsg, ...);
void WriteMessageLog(char *aMsg, ...);
void WriteStatusLog(char *aMsg, ...);
void WriteDebugLog(char *aMsg, ...);
void SetVirtual(int aVirtual);
int IsVirtual(void);

#endif
