/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#ifndef __prgdev__
#define __prgdev__
#include "libenv.h"
#include "prgtyp.h"

/***** makros *****************************************************************/
// . device
#define DEVICEName(apDevice)                   apDevice->dveName
#define BSDLFileNameOfDevice(apDevice)         apDevice->dveBsdlFileName
#define DATAInputFileNameOfDevice(apDevice)    apDevice->dveDFileInpName
#define DATAOutputFileNameOfDevice(apDevice)   apDevice->dveDFileOutName
#define ACTIONNameOfDevice(apDevice)           apDevice->dveActionName
#define DATANameOfDevice(apDevice)             apDevice->dveDataName
#define IRLengthOfDevice(apDevice)             apDevice->dveIrLength
#define ACTIONStatusOfDevice(apDevice)         apDevice->mActionStatus
// . bsdl info
#define GDvDRegList(p)    &(p->dveBsdlInfo->bsdDataRegList)
#define GDvInstList(p)    &(p->dveBsdlInfo->bsdInstList)
#define GDvActionList(p)  &(p->dveBsdlInfo->bsdActionList)
#define GDvProcList(p)    &(p->dveBsdlInfo->bsdProcList)
#define GDvIscFlowList(p) &(p->dveBsdlInfo->bsdIscFlowList)
#define DEVICEUserCode(apDevice)        apDevice->dveBsdlInfo->UserCode
#define DEVICEIdCode(apDevice)          apDevice->dveBsdlInfo->IdCode
#define DEVICETCKSignalStatus(apDevice) \
		apDevice->dveBsdlInfo->mTCKSignalStatus
#define DEVICECaptureIr(apDevice)       apDevice->dveBsdlInfo->dveIrCap
#define DEVICEIscStatus(apDevice)       apDevice->dveBsdlInfo->mIscStatus
#define DEVICEIscPins(apDevice)         apDevice->dveBsdlInfo->mIscPins
#define DEVICEIscProtect(apDevice)      apDevice->dveBsdlInfo->IscProtect
#define DEVICEBlankUserCode(apDevice)   apDevice->dveBsdlInfo->BlankUserCode
// . isc
#define GDvDataRecordList(p)	&(p->mActionStatus->mDataRecordList)
#define GETActionProc(apActProc) (apActProc)->aseProc
#define PROCEDUREListOfAction(apAction)           &apAction->aceProcList
#define FLOWListOfProcedure(apProcedure)          &apProcedure->preFlowList
#define LOOPCountOfBlock(apBlock)                 apBlock->exbLoopCount
// . activity
#define ACTIVITYListOfBlock(apBlock)              &apBlock->exbActList
#define INSTRUCTIONNameOfActivity(apActivity)     apActivity->facInstName
#define INSTRUCTIONCodeOfActivity(apActivity) \
		apActivity->facpInst->mInstructionOpCode
#define UPDATEFieldListOfActivity(apActivity)     &apActivity->UpdateFieldList
#define UPDATEFieldSumOfActivity(apActivity)			apActivity->mUpdateFieldSum
#define CAPTUREFieldListOfActivity(apActivity)    &apActivity->CaptureFieldList
#define CAPTUREFieldSumOfActivity(apActivity)			apActivity->mCaptureFieldSum
#define WAITMinStmtOfActivity(apActivity)         &apActivity->facWaitMin
#define WAITMaxStmtOfActivity(apActivity)         &apActivity->facWaitMax



/***** constants **************************************************************/
// Device Structure
#define IrCapMask 0x03
#define IrCapChk  0x01
// TCK Signal states
#define tckLow	0
#define tckHigh	1
// Data Register
#define dveNoOptStReg 0
#define dveOptStReg   1
// Isc status flag
#define fNotImplemented	0
#define fImplemented		1
// I/O Pins
#define pinOptHIGHZ 0
#define pinOptCLAMP 1
// Procedure options
#define preOptMand  0x0001
#define preOptRecom 0x0002
#define preOptOpt   0x0004
// Block options
#define bkInit  	   0
#define bkRepeat	   1
#define bkTerminate  2
#define cnoBit      -1
#define cnoId       -1
// Capture field
#define fopNoOutput 0
#define fopOutput   1
#define fNoCRC			0
#define fCRC				1
// Action options
#define cAst          "*"
#define	fNoExclOpt   0    // Action - PROPRIETARY
#define	fExclOpt     1
#define fMandAct      0		// Action - option (OPTIONAL / RECOMMENDED)
#define fOptionalAct  1
#define fRecommAct    2

#define iseOptISCInstruction 0x01 // ISC-Instruction
#define iseOptIscMand        0x02 // Mandatory Instruction
#define iseOptIllExit        0x04 // illegal Exit

#define ISCOpt               0
#define ISCMand              1
// execution result
#define resFail     0
#define resPass     1
#define resNoAction 2
#define resIgnoreFail 3

/***** data types *************************************************************/
// . enum
typedef enum _tOpType
{
	noOp = 0,
	opHexStringConstant,
	opAssignment,
	opInput,
	opPlus,
	opMinus,
	opComplement,
	opShl,
	opShr
} tOpType;

typedef enum _tProtect
{
	prtDisRead=0,
	prtDisProg,
	prtDisErase,
	prtDisKey,
	prtMsb,
	prtLsb
} tProtect;

// . bsdl 1149
// .. Data Register
typedef struct _tDataRegEnt
{
	TSTRING mDataRegName;
	int mId;
	int mLength;
} tDataRegEnt, *pDataRegEnt;
// .. Instruction
typedef struct _tInstructionEnt
{
	TSTRING mInstructionName;
	TSTRING mInstructionOpCode;
	int mDataRegId;    // Index of Data Register;
	pDataRegEnt mpDataReg;
	TSTRING mDataRegCapValue;      //  Capture-DR value
	int mOption;
} tInstructionEnt,*pInstructionEnt;

// . bsdl 1532
// .. variable
typedef struct _tVarEnt
{
	TSTRING varName;
	int varSize;
	tBitField varValue;
  int mInit;
} tVarEnt, *pVarEnt;
// .. data expression
typedef struct _tDataExpr
{
	pVarEnt mVarEnt;         // Pointer to Var-Stack
	TSTRING mVariable;
	TSTRING mHexStringOperand;
	int mIntegerOperand;
	tOpType mOpType;            // Type of Operation
} tDataExpr, *pDataExpr;
// .. duration specification
typedef struct _tDurationSpec
{
	TSTRING mPortId;
	int mCycleCount;
	double mTime;
} tDurationSpec, *pDurationSpec;
// .. update field
typedef struct _tUpFieldEnt
{
	int  Width;
	tDataExpr DataExpr;
	tBitField mValue;
} tUpFieldEnt, *pUpFieldEnt;
// .. capture field
typedef struct _tCapFieldEnt
{
	int Width;
	int ExpOutput;
	tDataExpr ExpectData;
	int CapOutput;
	int CRCtag;
	tDataExpr CompMask;
	tBitField mValue;
	tBitField mMaskValue;
	int mMask;
} tCapFieldEnt, *pCapFieldEnt;
// .. flow activity
typedef struct _tFlowActEnt
{
	TSTRING facInstName;       // Name of INstruction
	int facInstId; 	           // Instruction Id
	pInstructionEnt facpInst;	 // Pointer to the Instruction
	tDurationSpec facWaitMin;
	tDurationSpec facWaitMax;
	tList UpdateFieldList;
	int mUpdateFieldSum;      // sum of field width of Updatefileds of Activity
	tList CaptureFieldList;
	int mCaptureFieldSum;     // sum of field width of Capture fileds  of Activity
	int mLine;
} tFlowActEnt, *pFlowActEnt;
// .. flow block
typedef struct _tExecBlock
{
	tList exbActList;        // List of activities
	TSTRING exbName;
	int exbLoopCount;         // Repeat Block only
} tExecBlock, *pExecBlock;
// .. isc flow
typedef struct _tIscFlowEnt
{
	int mLine;             // Line in BSDL-File
	TSTRING ifeFlowName;
	TSTRING ifeDataName;
	pExecBlock ifeBlocks[3];	// Init Repeat and Done Block
	tList VarStack;           // Variablen Stack
	int currBlockId;          // Current Block Id: for parser
} tIscFlowEnt, *pIscFlowEnt;
// .. isc procedure
typedef struct _tProcEnt
{
	int preLine;
	TSTRING preName;
	TSTRING preDataName;
	tList preFlowList;  // List of Pointer to Flow
	unsigned char preOption;
} tProcEnt, *pProcEnt;
// .. procedure of action
typedef struct _tActProcEnt
{
	TSTRING aseProcName;
	TSTRING aseDataName;
	pProcEnt aseProc;     // Pointer to Procedure
	int options;
	int prop;
} tActProcEnt, *pActProcEnt;
// .. isc action
typedef struct _tActionEnt
{
	TSTRING aceName;
	TSTRING aceDataName;
	tList aceProcList;    // List of Procedures ActSpecEnt
	int prop;
} tActionEnt, *pActionEnt;
// ..
struct IscInstStruc
{
	int Mand;
	char * ISCName;
};

// . 1532 data
typedef struct _tDataRecord
{
	TSTRING mDataName;
	long mInitBlockPos;
	long mRepeatBlockPos;
	long mTerminateBlockPos;
/*	TFPOS mInitBlockPos;
	TFPOS mRepeatBlockPos;
	TFPOS mTerminateBlockPos; */
} tDataRecord, *pDataRecord;

// . device structure (global)
// .. action status (for vector synth.)
typedef struct _tActionStatus
{
	int mProgram;
	int mError;
  int mResult;
	// loop states - code
	int mProcedureCount;
	int mProcedureIndex;
	int mFlowCount;
	int mFlowIndex;
	int mBlockIndex;
	int mBlockLoopCount;
  int mBlockLoopIndex;
	int mActivityCount;
	int mActivityIndex;
	int mCodeIndex;
  // current entities - code
	pActionEnt mAction;
	pProcEnt mProcedure;
	pIscFlowEnt mFlow;
	pExecBlock mBlock;
	pFlowActEnt mActivity;
  TSTRING mBypassInstruction;
/* Frank Phillips @ Xilinx Added the following two lines on
May_01_2001 */
    TSTRING mEnableInstruction;
    TSTRING mDisableInstruction;
	TSTRING mInstruction;
	pDurationSpec mWaitMin;
	// loop states - parameter
	int mBypassInstructionBitCount;
	int mBypassInstructionBitIndex;
	int mInstructionBitCount;
	int mInstructionBitIndex;
  int mBypassParameterBit;
 	int mUpdateFieldIndex;
	int mCaptureFieldIndex;
	int mUFBitIndex;
	int mUFBitCount;
	int mCFBitIndex;
	int mCFBitCount;
  int mDoneUpdateFieldValue;
	// current entities - parameter
	pUpFieldEnt mUpdateField;
	pCapFieldEnt mCaptureField;
	tBitField mUFValue;
	tBitField mCFValue;
	tBitField mMaskValue;
	// data input
  TFILE1532Data mDataInputFile;
	TSTRING mInputRecordName;
	TSTRING mInputHexString;
	tList mDataRecordList;
	int mBlockEnd;
  long mCurrentFilePos;
	#ifdef DEBUG
		int mWriteProcedureName;
		int mWriteFlowName;
		int mWriteBlockId;
		int mWriteBlockLoopIndex;
		int mWriteActivityName;
    int mWriteUFValueType;
		TSTRING mUFValueType;
		int mWriteCFValueType;
		TSTRING mCFValueType;
		TSTRING mMaskValueType;
	#endif
} tActionStatus, *pActionStatus;
// .. bsdl info
typedef struct _tBSDLInfo
{
	tList bsdInstList;  //Instructions of a device
	tList bsdDataRegList;
	tList bsdActionList;
	tList bsdProcList;
	tList bsdIscFlowList;

	TSTRING UserCode;
	TSTRING IdCode;
	int mTCKSignalStatus;
	TSTRING dveIrCap; // Capture-IR
	int mIscStatus;
	int mIscPins;
	int IscProtect [prtLsb];
	TSTRING BlankUserCode;  // User-Code for blank device
} tBsdlInfo, *pBsdlInfo;
// .. device
typedef struct _tDevEnt
{
	TSTRING dveName;
	TSTRING dveBsdlFileName;     // optional
	TSTRING dveDFileInpName; // optioanl Data input File
	TSTRING dveDFileOutName; // optional Data output File
	TSTRING dveActionName;  //  optional Action for the Device
	TSTRING dveDataName;
	pBsdlInfo dveBsdlInfo; // Data reads from BSDL
	int dveIrLength;

    pActionStatus mActionStatus;
	TSTRING mSemantikErrors;
} tDevEnt, *pDevEnt;

/***** init data **************************************************************/
/*
struct IscInstStruc ISCInstrList[] =
{
	{ ISCMand, "ISC_ENABLE"          },
	{ ISCMand, "ISC_DISABLE"         },
	{ ISCMand, "ISC_PROGRAM"         },
	{ ISCMand, "ISC_NOOP"            },
	{ ISCOpt,  "ISC_READ"            },
	{ ISCOpt,  "ISC_ERASE"           },
	{ ISCOpt,  "ISC_PROGRAM_USERCODE"},
	{ ISCOpt,  "ISC_DISCHARGE"       },
	{ ISCOpt,  "ISC_PROGRAM_DONE"    },
	{ ISCOpt,  "ISC_ERASE_DONE"      },
	{ ISCOpt,  "ISC_PROGRAM_SECURITY"},
	{ ISCOpt,  "ISC_READ_INFO"       },
	{ ISCOpt,  "ISC_DATA_SHIFT"      },
	{ ISCOpt,  "ISC_SETUP"           },
	{ ISCOpt,  "ISC_ADDRESS_SHIFT"   },
	{ ISCOpt,  "ISC_INCREMENT"       }
};
*/

/***** function prototypes ****************************************************/
// init and free
pDevEnt   InitDevice(PSTRING aName);
void FreeDevice(void  *apDevice);
pBsdlInfo InitBsdlInfo(void);
void FreeBsdlInfo(pBsdlInfo aInfo);
pActionStatus InitActionStatus(void);
void FreeActionStatus(pActionStatus apActionStatus);
pDataExpr InitDataExpr(void);
void FreeDataExpr(pDataExpr aDataExpr);
void DoneDataExpr(pDataExpr aDataExpr);
pDurationSpec InitDurationSpec(void);
void DoneDurationSpec(pDurationSpec aDurationSpec);
void FreeDurationSpec(pDurationSpec aDurationSpec);
pIscFlowEnt  InitFlow(PSTRING aFlowName, PSTRING aDataName, int aLine);
void FreeFlow(void *aFlos);
pExecBlock InitExecBlock(PSTRING aName,int aLoopCount);
void FreeExecBlock(pExecBlock);
pFlowActEnt InitFlowAct(PSTRING aName);
void FreeFlowAct(pFlowActEnt aAct);
pVarEnt InitVar(PSTRING aName, int aSize);
void FreeVar(void  *aVar);
pUpFieldEnt InitUpField(int aWidth, pDataExpr aExpr);
FreeUpField(pUpFieldEnt aUpField);
pCapFieldEnt InitCapField(int aWidth, pDataExpr aExpr);
FreeCapField( pCapFieldEnt aCapField);
pProcEnt InitProc(PSTRING aName, PSTRING aDataName, int aLine);
void FreeProc (void  *aProc);
pActionEnt InitAction(PSTRING aName,PSTRING aDataName);
void FreeAction(void  *aAct);
pActProcEnt InitActProc(PSTRING aName,PSTRING aDataName);
FreeActProc(pActProcEnt aActSpec);
pDataRecord InitDataRecord(PSTRING aDataName);
void DoneDataRecord(pDataRecord apDataRecord);
//void FreeDataRecord(pDataRecord apDataRecord);
// list handling
int AddVar(pList aList, PSTRING aName, int aSize, int *aIndex);
pList GetCurrentActList(pDevEnt aDevEnt);

// Functions called from command file parser
// . Files
void SetBsdlFileName(pDevEnt aDevEnt, PSTRING aFileName);
void SetDataInputFileName(pDevEnt aDevEnt, PSTRING aFileName);
void SetDataOutputFileName(pDevEnt aDevEnt, PSTRING aFileName);
// Action
void SetActionName(pDevEnt aDevEnt, PSTRING aActionName);
void SetDataName(pDevEnt aDevEnt, PSTRING aDataName);

// Functions called from bsdl file parser
// Standard IEEE_1149.1_1994:
int SetTCKSignalStatus(pDevEnt apDevEnt, int aStatus, int aLine);
// . instruction
int PutIrLength(pDevEnt aDevEnt, int aIrLength, int aLine);
int AddInstruction(pDevEnt aDevEnt, PSTRING aInst, int aLine);
void FreeInstruction(void *aInst);
int AddOpCode(pDevEnt aDevEnt,PSTRING aCode, int aLine);
int AddIrCapVal(pDevEnt aDevEnt, PSTRING aIrCap,int aLine);
// . id and user code register
int AddIdCode(pDevEnt aDevEnt, PSTRING aCode, int aLine);
int AddUserCode(pDevEnt aDevEnt, PSTRING aCode, int aLine);
// . register access
int AddDataReg(pDevEnt aDevEnt, PSTRING aName, int aLength, int aLine);
int AddInstToDR(pDevEnt aDevEnt, PSTRING aName, PSTRING aCapVal, int aLine);

// Functions called from bsdl file parser
// Standard IEEE_1532_2000:
// . isc status and pin behavior
int SetStatus(pDevEnt aDevEntint, int aState, int aLine);
int SetPinBehavior(pDevEnt aDevEnt, int aPinOpt, int aLine);
// . blank user code register
int SetBlankUserCode(pDevEnt aDevEnt, PSTRING aCode, int aLine);
// . protection
int SetProtectionBits(pDevEnt aDevEnt, int aRead, int aProg, int aEra, int aLine);
int SetProtectionKeyRange(pDevEnt aDevEnt, int aMsb, int aLsb, int aLine);
// . flow
int AddFlow(pDevEnt aDevEnt, PSTRING aFlowName, PSTRING aDataName, int aLine);
// .. block
int AddFlowBlock(pDevEnt aDevEnt, int aBlockId, int aLoopCount, int aLine);
// ... activity
int AddFlowActivity(pDevEnt aDevEnt, PSTRING aInstructionName, int aLine);
// .... update
int AddUpdateField(pDevEnt aDevEnt, int aWidth, pDataExpr aDataExpr, int aLine);
// .... wait
int AddWaitDurMin(pDevEnt aDevEnt, pDurationSpec aDurationSpec, int aLine);
int AddWaitDurMax(pDevEnt aDevEnt, pDurationSpec aDurationSpec, int aLine);
// .... capture
int AddCaptureField(pDevEnt aDevEnt, int aWidth, int aOutputOp, pDataExpr aDataExpr,
			int aLine);
int SetCRC(pDevEnt aDevEnt, int aCRC, int aLine);

int AddCompareMask(pDevEnt aDevEnt, int aOutputOp, pDataExpr aDataExpr, int aLine);
// . procedure
int AddProcedure(pDevEnt aDevEnt, PSTRING aProcName, PSTRING aDataName, int aLine);
int AddProcFlow(pDevEnt aDevEnt, PSTRING aFlowName, PSTRING aDataName, int aLine);
// . action
int AddAction(pDevEnt aDevEnt, PSTRING aActionName, PSTRING aDataName, int aPROPRIETARY,
			int aLine);
int AddActionSpec(pDevEnt aDevEnt, PSTRING aProcName, PSTRING aDataName, int aPROPRIETARY,
			int OptRec, int aLine);
// . illegal exit
int AddExitInstruction(pDevEnt aDevEnt, PSTRING aExitInstr, int aLine);

// Functions called from data file parser
// Standard IEEE_1532_2000:
int AddDataRecord(pDevEnt aDevEnt, PSTRING aDataName, int aLine);
//int AddDataBlock(pDevEnt aDevEnt, int aBlockId, TFPOS aFilePos, int aLine);
int AddDataBlock(pDevEnt aDevEnt, int aBlockId, long aFilePos, int aLine);
pDataRecord GetDataRecordByName(pActionStatus apStatus, PSTRING aDataName);

// Semantik check
int BsdlSemanticCheck(pDevEnt apDevice);
int DataSemanticCheck(pDevEnt apDevice);

// Functions called from vector synthesizer and interpreter
pActionEnt GetActionByName(pDevEnt aDevEnt, PSTRING aActionName, PSTRING aDataName);
pProcEnt GetProcedureByName(pDevEnt apDevice, PSTRING aProcName);
pActionStatus InitActionStatus(void);
int GetBypassInstructionCodeOfDevice(pDevEnt apDevice, PSTRING aCode);
/* Frank Phillips @ Xilinx Added the following two functions on
May_01_2001 */
int GetEnableInstructionCodeOfDevice(pDevEnt apDevice, PSTRING aCode);
int GetDisableInstructionCodeOfDevice(pDevEnt apDevice, PSTRING aCode);
pInstructionEnt GetInstructionByName(pDevEnt apDevice, PSTRING aInstructionName);

/***** list functions *********************************************************/
// item keys
void *KeyOfInstList(void *aItem);
void *KeyOfDRList(void *aItem);
void *KeyOfFlowList(void *aItem);
void *KeyOfProcList(void *aItem);
void *KeyOfAction(void *aItem);
void *KeyOfVarStack(void *aItem);
void *KeyOfDataRecordList(void *aItem);
// compare
int ComparepString(void * aStr1, void *aStr2);
int CompareIscFlow(void *aFlow1, void *aFlow2);
int CompareProc(void *aProc1, void *aProc2);
int CompareAction(void *aAction1, void *aAction2);

pExecBlock GetBlockAtIndex(pIscFlowEnt aFlow, int aIndex);

pCapFieldEnt GetLastCapField(pDevEnt aDevEnt);
#endif





