/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#include <stdio.h>
#include "sysopenv.h"
#include "libenv.h"
#include "prgtyp.h"

#define ilmxCount 32
#define  loptNOFREE 0x00000001
pList NewList(uint32 aOption)
{
	pList aList;
	aList = (pList)GETMem(sizeof(tList));
	InitList(aList, aOption);
	return aList;
}

void InitList(pList aList,uint32 aOption)
{
//  aList = GETMem(sizeof(tList));
  int vItemSize;
  FILLChar(aList, 0, sizeof(tList));
  aList->mOption  = aOption;
  aList->Count   = 0;
  aList->MaxCount = ilmxCount;
  vItemSize = aList->MaxCount * sizeof(void *);
  aList->items = (unsigned*)GETMem(vItemSize);
  FILLChar( aList->items, 0, vItemSize);
}

void AddListItem(pList aList,void *aptr)
{
 int iCount = aList->Count;
 int    vMaxCount = aList->MaxCount;

 if (iCount >= vMaxCount)
 {
    void * NewItems;
	int NewMaxCount;
	int vItemSize;

	if (vMaxCount < 50)
		NewMaxCount = 64;
	else if (vMaxCount < 2048)
	    NewMaxCount = vMaxCount << 1;
	else NewMaxCount = vMaxCount + 2048;
	vItemSize = NewMaxCount * sizeof(void *);
	NewItems = (unsigned*)GETMem(vItemSize);
	 //	FILLChar( aList->items, 0, vItemSize);
   FILLChar( NewItems, 0, vItemSize);

	vItemSize = vMaxCount * sizeof(void *);
		COPYMemDSC(NewItems, aList->items, vItemSize);
	FREEMem(aList->items, vItemSize);

	aList->items = (unsigned*)NewItems;
	aList->MaxCount = NewMaxCount;
	}

  aList->items[iCount] = (unsigned)aptr;
  aList->Count++;
}

void *GetItemAtIndex(pList aList, int aIndex)
{  int vCount;
   void *rt = NULL;
   if (aList != NULL) {
     vCount = ITEMCountOfList(aList);
     if ((aIndex >=0 ) && (aIndex < vCount))
     rt =  (void*)aList->items[aIndex];
   };
   return(rt);
};
// Free the whole List with Data
void DoneList(pList aList)
{int vIdx;
 void *vItem;
  if (aList->items!=NULL)
  {  if (aList->mOption & loptFREE) {
       if (aList->fFreeItem) {
         for(vIdx=0; vIdx<aList->Count; vIdx++) {
             vItem = aList->items[vIdx];
             if (vItem)
               aList->fFreeItem(vItem);
         };// for
       };// fItem
     };// FREE ?
     FREEMem( aList->items, aList->MaxCount * sizeof(void *));
  };
};

void FreeList(pList aList)
{

  if (aList != NULL)
  {
   	DoneList(aList);
   	FREEMem(aList, sizeof(tList));
  }
}



int intCompare(void *aKey1, void *aKey2)
{int ret = 1;

 if (*(int *)aKey1 < *(int *)aKey2) {
	ret = -1;
 }else {
	if (*(int *)aKey1 == *(int *)aKey2)
	  ret = 0;
		 };
 return(ret);
}
void SetListFunc(pList aList, pfCompare aCompare,pfKeyOf aKeyOf,pfFreeItem aFreeItem)
{
  if (aList != NULL) {
 	 (aList)->fCompare  = aCompare;
	 (aList)->fKeyOf    = aKeyOf;
    (aList)->fFreeItem = aFreeItem;
  };
};
// Searching without sorting
int  lSearchList(pList aList, void *aKey, int *aIdx )
{void *p = NULL;
 int iCount = (aList)->Count;
 int idx;
 void *Key;
 for (idx=0;idx < iCount;idx++)  {
	p = (void*)(aList)->items[idx];
   Key = (aList)->fKeyOf(p);
	if ((aList)->fCompare(aKey,Key) == 0) {
		*aIdx = idx;
		return(1);
	 };
  };// for idx
  return(0);
};

/***** bit field functions ****************************************************/

/* -------------------------------------------------------------------------- */
pBitField NewBitField(int aSize)
{
	pBitField vpBitField = (pBitField)GETMem(sizeof(tBitField));
	if (vpBitField != NULL)
		InitBitField(vpBitField, aSize);
	return(vpBitField);
}

/* -------------------------------------------------------------------------- */
void  InitBitField(pBitField apBitField, int aSize)
{
	int vCount = (aSize / 8) + ((aSize % 8) ? 1:0);
	int vIdx;

	// One Byte
	if (vCount == 0)
		vCount = 1;

	FILLChar(apBitField, 0, sizeof(tBitField));
	apBitField->mSize  = aSize;
	apBitField->mCount = vCount;
	apBitField->mBytes = (tByte *) GETMem(vCount * sizeof(tByte));

	// Init the Bitfield to zero
	if (apBitField->mBytes != NULL)
	    FILLChar(apBitField->mBytes, 0, vCount * sizeof(tByte));
//		for (vIdx = 0; vIdx < vCount; vIdx++)
//			apBitField->mBytes[vIdx] = apBitField->mBytes[vIdx] >> 8;
}

/* -------------------------------------------------------------------------- */
void FreeBitField(pBitField apBitField)
{
	if (apBitField != NULL)
	{
		DoneBitField(apBitField);
		FREEMem(apBitField, sizeof(tBitField));
	}
}

/* -------------------------------------------------------------------------- */
void DoneBitField(pBitField apBitField)
{
	if (apBitField != NULL)
	{
		if (apBitField->mBytes)
		{
		   FREEMem(apBitField->mBytes, apBitField->mCount * sizeof(tByte));
		}
		apBitField->mSize  = 0;
		apBitField->mCount = 0;
	}
}

/* -------------------------------------------------------------------------- */
int BitAtIndex(pBitField apBitField, int aIndex)
{
	tByte vByte;

	if (aIndex > apBitField->mSize)
		return -1;

	vByte = apBitField->mBytes[aIndex / 8];
	vByte = vByte >> (aIndex % 8);
	return (vByte & 0x01);
}

/***** bit field conversion ***************************************************/

/* -------------------------------------------------------------------------- */
int HexToBitField(pBitField apResBits, PSTRING aHexStr, int aSize)
{
	unsigned char vHigh, vLow;
	tByte vByte;
	int i, x;
	int vCount;

//	DoneBitField(apResBits);
	InitBitField(apResBits, aSize);
	vCount = 0;
	x = STRLen(*aHexStr) % 2;
	for (i = STRLen(*aHexStr) - 1; i >= 0; i--)
	{
		// check size (bytes)
		if (vCount >= apResBits->mCount)
			if (STRPChar(*aHexStr)[i] != '0')
			{
				WRITEError("\n...Error - there are unused bits in hex string \"%s\".\n",
					STRPChar(*aHexStr));
				return rtErr;
			}
			else
				continue;

		// conversion
		if ((i % 2) - x)
		{
			vLow = HexDigitToInt(STRPChar(*aHexStr)[i]);
			if (vLow > 15)
				return rtErr;
			apResBits->mBytes[vCount] |= vLow;
		}
		else
		{
			vHigh = HexDigitToInt(STRPChar(*aHexStr)[i]);
			if (vHigh > 15)
				return rtErr;
			apResBits->mBytes[vCount] |= vHigh << 4;
			vCount++;
		}
	}
	// check size (bits)
	i = 0;
	vByte = apResBits->mBytes[vCount - 1];
	while (0xFF & vByte)
	{
		vByte = vByte >> 1;
		i++;
	}
	if (((vCount - 1) * 8 + i) > (apResBits->mSize))
	{
		WRITEError("\n...Error - there are unused bits in hex string \"%s\".\n",
			STRPChar(*aHexStr));
		return rtErr;
	}
	return rtOk;
}

/* -------------------------------------------------------------------------- */
char HexDigitToInt(char aHexDigit)
{
	if ((aHexDigit >= 'A') && (aHexDigit <= 'F'))
		return (aHexDigit - 'A' + 10);
	if ((aHexDigit >= 'a') && (aHexDigit <= 'f'))
		return (aHexDigit - 'a' + 10);
	if ((aHexDigit >= '0') && (aHexDigit <= '9'))
		return (aHexDigit - '0');
	if (aHexDigit == 0)
		return 0;
	WRITEError("\n...Error - no hex digit: %c\n", aHexDigit);
	return -1;
}

/* -------------------------------------------------------------------------- */
int IntToBitField(pBitField apResBits, int aOperand, int aSize)
{
	int i, vOp;

	InitBitField(apResBits, aSize);

	// check size (bits)
	i = 0;
	vOp = aOperand;
	while (0xFFFF & vOp)
	{
		vOp = vOp >> 1;
		i++;
	}
	if (i > apResBits->mSize)
		return rtErr;

	// conversion
	apResBits->mBytes[0] = aOperand;
	if (apResBits->mCount > 1)
	{
		aOperand = aOperand >> 8;
		apResBits->mBytes[1] = aOperand;
	}
	return rtOk;
}

/***** bit field operations ***************************************************/

/* -------------------------------------------------------------------------- */
int ComplementOfBitField(pBitField apResBits)
{
	int i;
	int vMask;

	if (apResBits != NULL)
	{
		for (i = 0; i < apResBits->mCount; i++)
			apResBits->mBytes[i] = ~apResBits->mBytes[i];
		// complement bits in size range only
		vMask = 0xff >> (8 - apResBits->mSize % 8);
		if (vMask != 0x00)
			apResBits->mBytes[apResBits->mCount - 1] &= vMask;
		return rtOk;
	}
	return rtErr;
}

/* -------------------------------------------------------------------------- */
int AddBitFields(pBitField apResBits, tBitField aValue)
{
	int i, vOverflow;

	if (aValue.mSize > apResBits->mSize)
		return rtErr;

	vOverflow = 0;
	for (i = 0; i < apResBits->mCount; i++)
	{
		apResBits->mBytes[i] = apResBits->mBytes[i] + aValue.mBytes[i] + vOverflow;
		vOverflow = apResBits->mBytes[i] < aValue.mBytes[i];
	}
	return rtOk;
}

/* -------------------------------------------------------------------------- */
int SubBitFields(pBitField apResBits, tBitField aValue)
{
	int i, vOverflow;

	if (aValue.mSize > apResBits->mSize)
		return rtErr;

	vOverflow = 0;
	for (i = 0; i < apResBits->mCount; i++)
	{
		apResBits->mBytes[i] = apResBits->mBytes[i] - aValue.mBytes[i] - vOverflow;
		vOverflow = apResBits->mBytes[i] > aValue.mBytes[i];
	}
	return rtOk;
}

/* -------------------------------------------------------------------------- */
int ShiftLeftBitField(pBitField apResBits, int aOperand)
{
	int i, j;
	unsigned vShBitIn, vShBitOut;

	if (aOperand > apResBits->mSize)
		return rtErr;

	for (i = 0; i < aOperand; i++)
	{
		vShBitIn = 0x00;
		for (j = 0; j < apResBits->mCount; j++)
		{
			vShBitOut = 0x80 & apResBits->mBytes[j];
			apResBits->mBytes[j] = (apResBits->mBytes[j] << 1) | vShBitIn;
			vShBitIn = vShBitOut >> 7;
		}
	}
	return rtOk;
}

/* -------------------------------------------------------------------------- */
int ShiftRightBitField(pBitField apResBits, int aOperand)
{
	int i, j;
	unsigned vShBitIn, vShBitOut;

	if (aOperand > apResBits->mSize)
		return rtErr;

	for (i = 0; i < aOperand; i++)
	{
		vShBitIn = 0x00;
		for (j = apResBits->mCount - 1; j >= 0; j--)
		{
			vShBitOut = 0x01 & apResBits->mBytes[j];
			apResBits->mBytes[j] = (apResBits->mBytes[j] >> 1) | vShBitIn;
			vShBitIn = vShBitOut << 7;
		}
	}
	return rtOk;
}


