/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#ifndef __prgtyp__
#define __prgtyp__

#include "libenv.h"
#include "logfkt.h"

/***** constants **************************************************************/
#define cnoId -1
// return values
#define rtOk    0x00
#define rtErr   0x01  // error
#define rtWrn   0x02  // warning

/***** macros *****************************************************************/
#define ITEMCountOfList(apList)           apList->Count
#define  loptFREE 0x00000001
/***** lists ******************************************************************/
// List structure
#ifndef uint32
typedef  unsigned int uint32;
#endif
//General Function types
typedef  void *tfKeyOf (void *aItem);
typedef  int tfCompare (void *aKey1,void *aKey2);
typedef  void tfFreeItem(void *aItem);
// Pointer to function
typedef  tfCompare *pfCompare;
typedef  tfKeyOf   *pfKeyOf;
typedef  tfFreeItem *pfFreeItem;

typedef struct {
  uint32 mOption;
  uint32 *items;
  int Count;      // Number of elements
  int MaxCount;   // Max Count
  pfCompare fCompare; // functions
  pfKeyOf   fKeyOf;
  pfFreeItem fFreeItem;
} tList, *pList;
// list functions
// . init and free
pList NewList(uint32 aOption);
void FreeList(pList aList);
void InitList(pList aList, uint32 aOption);
void DoneList(pList aList);
// . list handling
void AddListItem(pList aList, void *aptr);
int  GetItemCountOfList(pList aList);
void *GetItemAtIndex(pList aList,int aIndex);
int  IntCompare(void *aKey1, void *aKey2);
int  lSearchList(pList aList, void *aKey, int *aIdx );
void SetListFunc(pList aList, pfCompare aCompare, pfKeyOf aKeyOf, pfFreeItem aFreeItem);

/***** bit fields *************************************************************/
// bit field structure
typedef struct _tBitField
{
    int mSize;  // Size in Bits
    int mCount;  // Number of Byte Entries
    tByte *mBytes;
} tBitField, *pBitField;
// bit field functions
pBitField NewBitField(int aSize);
void FreeBitField(pBitField aBits);
void InitBitField(pBitField aBits, int aSize);
void DoneBitField(pBitField aBits);
int BitAtIndex(pBitField apBits, int aIndex);
// . bit field conversion
int HexToBitField(pBitField apResBits, PSTRING aHexStr, int aSize);
char HexDigitToInt(char aHexDigit);
int IntToBitField(pBitField apResBits, int aOperand, int aSize);
// . bit field operations
int ComplementOfBitField(pBitField apResBits);
int AddBitFields(pBitField apResBits, tBitField aValue);
int SubBitFields(pBitField apResBits, tBitField aValue);
int ShiftLeftBitField(pBitField apResBits, int aOperand);
int ShiftRightBitField(pBitField apResBits, int aOperand);

#endif
