/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#include "sysopenv.h"
#include "libenv.h"
#include "prgdev.h"
#include "progty.h"

#include "pCommand.h"
#include "pbsdl.h"
#include "pdata.h"
#include "interpr.h"
#include "logfkt.h"

/***** function prototypes ****************************************************/
void WriteHelp(void);

/* -------------------------------------------------------------------------- */
/* --- prog1532 main                                                      --- */
/* -------------------------------------------------------------------------- */
main (int argc, char **argv)
{
    int i;
    pProg1532 vProg1532;
    pDevEnt vpDevice;
    pActionStatus vpStatus;

    TTIME vStartTime, vEndTime;
  int vDuration;

    int vOptions = 0;
    int vResult = rtOk;

    TSTRING vArgument;
    TSTRING vCommandFileName;
    TSTRING vLogFileName;

	// The following variables were added by Frank Phillips @ Xilinx
	// to enable concurrent and sequential programming on
	// May_10_2001
	TSTRING vProgModeName;
	int vprogModeFound;

    // init
    InitLog();

    STRInit(vCommandFileName, "");
    STRInit(vLogFileName, "");
    STRInit(vArgument, "");

	// The following variables were added by Frank Phillips @ Xilinx
	// to enable concurrent and sequential programming on
	// May_10_2001
	STRInit(vProgModeName, "");

    WRITEToScreen("Xilinx JDrive v3.00\n");


    for (i = 1; i < argc; i++)
    {
        STRChAssign(vArgument, argv[i]);

        if (STRLen(vArgument) > 1)
            if (STRPChar(vArgument)[0] == '-')
            {
                // add clocks
                if (STRChEqualNoCase(vArgument, "--addclocks")
                        || STRChEqualNoCase(vArgument, "-a"))
                {
                    vOptions |= vsOptAddClocks;
                    continue;
                }
                // debug option
                if (STRChEqualNoCase(vArgument, "--debug")
                        || STRChEqualNoCase(vArgument, "-d"))
                {
                    #ifdef DEBUG
                        SetLogOption(logDebug);
                    #else
                        WRITEToScreen("Warning: option --status/-s is disabled.\n");
                        WRITEToScreen("It's necessary to build the prog1532.exe with %s",
                            "compiler switch DEBUG to get detailed status information.\n\n");
                    #endif
                    continue;
                }
                // help option
                if (STRChEqualNoCase(vArgument, "--help")
                        || STRChEqualNoCase(vArgument, "-h"))
                {
                    WriteHelp();
                    vResult = rtErr;
                    break;
                }
                // (ignore compare) fail option
                if (STRChEqualNoCase(vArgument, "--fail_ignore")
                        || STRChEqualNoCase(vArgument, "-f"))
                {
                    vOptions |= vsOptIgnoreFail;
                    continue;
                }
                // log file option
                if (STRChEqualNoCase(vArgument, "--logfile")
                        || STRChEqualNoCase(vArgument, "-l"))
                {
					SetLogOption(logFile);
                    // get log file name
                    i++;
                    if (i < argc)
                    {
                        STRChAssign(vArgument, argv[i]);
                        if (STRPChar(vArgument)[0] != '-')
                        {
                            STRAssign(vLogFileName, vArgument);
                            continue;
                        }
                        // no log file name argument
                        i--;
                    }
                    continue;
                }
                // status option
                if (STRChEqualNoCase(vArgument, "--status")
                        || STRChEqualNoCase(vArgument, "-s"))
                {
                    SetLogOption(logStatus);
                    continue;
                }
                // virtual option
                if (STRChEqualNoCase(vArgument, "--virtual")
                        || STRChEqualNoCase(vArgument, "-v"))
                {
                    #ifdef DEBUG
                        SetVirtual(1);
                    #else
                        WRITEToScreen("Warning: option --virtual/-v is disabled.\n");
                        WRITEToScreen("It's necessary to build the prog1532.exe with %s",
                            "compiler switch VIRTUAL to get detailed status information.\n\n");
                    #endif
                    continue;
                }
                // programming mode option -- either concurrent or sequential
				// Added By Frank Phillips @ Xilinx on
				//May_10_2001
                if (STRChEqualNoCase(vArgument, "--mode")
                        || STRChEqualNoCase(vArgument, "-m"))
                {
                    // get programming mode 
                    i++;
                    if (i < argc)
                    {
                        STRChAssign(vArgument, argv[i]);
                        if (STRPChar(vArgument)[0] != '-')
                        {
                            STRAssign(vProgModeName, vArgument);
                            continue;
                        }
                        // no programming mode name 
                        i--;
                    }
                    continue;
                }
                // invalid option
                WRITEToScreen("Invalid option: %s.\n", STRPChar(vArgument));
                vResult = rtErr;
                break;
            }

        // command file name
        if (STRLen(vCommandFileName) == 0)
        {
            STRAssign(vCommandFileName, vArgument);
            continue;
        }
        // to much arguments
        else
        {
            WRITEToScreen("Warning: extra argument ignored: %s.\n\n", STRPChar(vArgument));
            continue;
        }
    }
    // abort, if no command file given
    if (! vResult)
        if (STRLen(vCommandFileName) == 0)
        {
            WRITEToScreen("No command file given.\n");
            WriteHelp();
            vResult = rtErr;;
        }
    // set log file
    if (! vResult)
        if (LOGFile)
        {
            // if no log file name given:
            // --> log file name = command file name + ".log"
            if (STRLen(vLogFileName) == 0)
            {
                STRAssign(vLogFileName, vCommandFileName);
                STRChConcat(vLogFileName, ".log");
            }
            SetLogFile(STRPChar(vLogFileName));
        }
    STRDone(vArgument);
    STRDone(vLogFileName);
    // abort if invalid command
    if (vResult)
    {
        DoneLog();
        STRDone(vCommandFileName);
        return vResult;
    }

    // int scan chain structure
    vProg1532 = NewPrg();

	// set programing mode 
	// Added by Frank Phillips @ Xilinx on
	// May_10_2001
	vprogModeFound = 0;
	if (!STRLen(vProgModeName)== 0) {
		if (STRChEqualNoCase(vProgModeName, "Concurrent")) {
			vprogModeFound = 1;
		    vProg1532 -> progMode = 1;
		}
		else if (STRChEqualNoCase(vProgModeName, "Sequential")) {
	             vprogModeFound = 1;
		         vProg1532 -> progMode = 2;
		     }
	}
	
	if (!vprogModeFound) {
		WRITEToScreen("WARNING!...Invalid Mode option: ");
        WRITEToScreen("Using Sequential Programming Mode\n");
		vProg1532 -> progMode = 2;
	}	
	
    // start parsing
    WRITEStatus("Start file parsing:\n");
    GETTime(&vStartTime);

    // parse command file (fill scan chain structure)
    vResult = (parseCommandFile(vProg1532, STRPChar(vCommandFileName)));
    STRDone(vCommandFileName);

    // fill bsdl information per device
    if (! vResult)
        for (i = 0; i < GetDeviceCount(vProg1532); i++)
        {
            vpDevice = GetDeviceAtIndex(vProg1532, i);

            // parse bsdl file (syntax check, fill bsdl info)
            if (vResult = (parseBsdlFile(vpDevice) & rtErr))
                break;
            // check bsdl semantik
            if (vResult = (BsdlSemanticCheck(vpDevice) & rtErr))
                break;
            // parse data file (syntax check, get data record file positions)
            if (vResult = (parseDataFile(vpDevice) & rtErr))
                break; 
            // check data semantik
            if (vResult = (DataSemanticCheck(vpDevice) & rtErr))
                break;
        }
  // duration
    GETTime(&vEndTime);
    vDuration = TIMEDiff(vEndTime, vStartTime);
    WRITEStatus("Parsing duration: %d:%2d min\n", (vDuration / 60), (vDuration % 60));
    // abort if error during parsing
    if (vResult)
    {
        WRITEMessage("Aborted !\n");
    FreePrg(vProg1532);
        DoneLog();
        return vResult;
    }

    // start isc execution
    WRITEStatus("\nStart execution:");
    GETTime(&vStartTime);

    // open data files
    for (i = 0; i < GetDeviceCount(vProg1532); i++)
    {
        vpDevice = GetDeviceAtIndex(vProg1532, i);
        vpStatus = ACTIONStatusOfDevice(vpDevice);

        if (STRLen(DATAInputFileNameOfDevice(vpDevice)) > 0)
            OPEN1532DataFileRO(vpStatus->mDataInputFile,
                STRPChar(DATAInputFileNameOfDevice(vpDevice)));
    }
    // vector synthesizer (program devices)
    vResult
        = (VectorSynthesizer(vProg1532, vOptions) & rtErr);
    // close data filesls

    for (i = 0; i < GetDeviceCount(vProg1532); i++)
    {
        vpDevice = GetDeviceAtIndex(vProg1532, i);
        vpStatus = ACTIONStatusOfDevice(vpDevice);
        if (STRLen(DATAInputFileNameOfDevice(vpDevice)) > 0)
            CLOSE1532DataFile(vpStatus->mDataInputFile);
    }
    // results
  for (i = 0; i < GetDeviceCount(vProg1532); i++)
    {
        vpDevice = GetDeviceAtIndex(vProg1532, i);
        vpStatus = ACTIONStatusOfDevice(vpDevice);
        switch (vpStatus->mResult)
        {
            case resFail:
                WRITEStatus("\n...device %s: fail", STRPChar(DEVICEName(vpDevice)));
                break;
            case resIgnoreFail:
                WRITEStatus("\n...device %s: fail (ignored)", STRPChar(DEVICEName(vpDevice)));
                break;
            case resPass:
                WRITEStatus("\n...device %s: pass", STRPChar(DEVICEName(vpDevice)));
                break;
            case resNoAction:
                WRITEStatus("\n...device %s: no action", STRPChar(DEVICEName(vpDevice)));
                break;
        }
    }
  // duration
    GETTime(&vEndTime);
    vDuration = TIMEDiff(vEndTime, vStartTime);
    WRITEStatus("\nExecution duration: %d:%2d min\n", (vDuration / 60), (vDuration % 60));
    // execution aborted or successful
    if (vResult)
        WRITEMessage("Aborted.\n");
    else
        WRITEMessage("Successful.\n");

    // done
    FreePrg(vProg1532);
    DoneLog();
    return vResult;
}

/* -------------------------------------------------------------------------- */
/* --- displays command line options                                      --- */
/* -------------------------------------------------------------------------- */
void WriteHelp()
{
    WRITEToScreen(
        "Usage:  JDrive [-adfhsv] [-l [log-file-name]] [--addclocks] [--debug]%s%s",
        "\n        [--fail_ignore] [--help] [--logfile] [log-file-name]] [--status]",
        "\n        [--virtual] command-file -m concurrent or sequential");
}


