/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#include "progty.h"

pProg1532 NewPrg(void)
{ pProg1532 Prog = NULL;
  Prog = (pProg1532 *)GETMem(sizeof(tProg1532));
  if (Prog !=NULL)
    InitPrg(Prog);
  return(Prog);
};
void InitPrg(pProg1532 aProg)
{ pfCompare vfComp;  // Comparefunction for List
  pfKeyOf   vfKeyOf; // KeyOf Function  for List
  pfFreeItem vfFreeItem;

  if (aProg != NULL) {
    FILLChar(aProg,0,sizeof(tProg1532));
    InitList(&aProg->prgDevList,loptFREE);
    vfComp  = ComparepString;
    vfKeyOf = KeyOfDevList;
    vfFreeItem = FreeDevice;
    if (&aProg->prgDevList !=NULL)  {
      SetListFunc(&aProg->prgDevList,vfComp,vfKeyOf, vfFreeItem);
    }

	// Added by Frank Phillips @ Xilinx on
    // May_10_2001 
    // aProg->progMode= 0;

//	&aProg->progMode = 0;
  };
};


int DonePrg(pProg1532 aProg)
{
  if (aProg !=NULL) {
    DoneList(&aProg->prgDevList);
  };
  return 0;
};
int FreePrg(pProg1532 aProg)
{
  if (aProg !=NULL) {
    DonePrg(aProg);
    FREEMem(aProg,sizeof(aProg));
  };
  return 0;
};
int AddDevice(pProg1532 aProg,PSTRING aDevName)
{pDevEnt vDevEnt = NULL;
 int idx = 0;
 int rt = rtOk;
 pList vDevList = &aProg->prgDevList;
 if (lSearchList(vDevList,aDevName,&idx)) {
   rt = rtErr;
     WRITEError("...\nError - Device with name %s already exists.", STRPChar(*aDevName));
 } else {
    vDevEnt = InitDevice(aDevName);
    if (vDevEnt!=NULL ) {
      AddListItem(vDevList,(void *)vDevEnt);
    };// vDevEnt
 };
 return 0;
};


void SetDevBsdlName(pProg1532 aProg, PSTRING aName)
{pDevEnt vDevEnt = GetLastDevice(aProg);

 if (vDevEnt !=NULL) {
    SetBsdlFileName(vDevEnt, aName);
 };
};

void SetDevDFInpName(pProg1532 aProg, PSTRING aName)
{pDevEnt vDevEnt = GetLastDevice(aProg);

 if (vDevEnt !=NULL) {
   SetDataInputFileName(vDevEnt,aName);
 };
};

void SetDevDFOutName(pProg1532 aProg, PSTRING aName)
{pDevEnt vDevEnt = GetLastDevice(aProg);

 if (vDevEnt !=NULL) {
   SetDataOutputFileName(vDevEnt, aName);
 };
};

void SetDevActionName(pProg1532 aProg, PSTRING aName)
{pDevEnt vDevEnt = GetLastDevice(aProg);

 if (vDevEnt !=NULL) {
     SetActionName(vDevEnt, aName);
 };
};

void SetDevDataName(pProg1532 aProg, PSTRING aName)
{
    pDevEnt vDevEnt = GetLastDevice(aProg);

    if (vDevEnt !=NULL)
        SetDataName(vDevEnt, aName);
}

void SetDevIrLength(pProg1532 aProg, int aIrLength)
{
    pDevEnt vDevEnt = GetLastDevice(aProg);
    if (vDevEnt !=NULL)
        PutIrLength(vDevEnt, aIrLength, -1);
}

// Get the Last Device
pDevEnt GetLastDevice(pProg1532 aProg)
{pDevEnt rtDev = NULL;
 int iCount = 0;
  if (aProg != NULL) {
    if (&aProg->prgDevList != NULL) {
      iCount = aProg->prgDevList.Count;
      if (iCount > 0) {
        rtDev = aProg->prgDevList.items[iCount-1];
      };
    };
  };
  return(rtDev);
};
int GetDeviceCount(pProg1532 aProg)
{
    if (aProg != NULL)
        return aProg->prgDevList.Count;
    return 0;
}


pDevEnt GetDeviceAtIndex(pProg1532 aProg, int aIndex)
{
    pDevEnt rtDev = NULL;
    int iCount = 0;
    if (aProg != NULL)
    {
        if (&aProg->prgDevList != NULL)
        {
            iCount = aProg->prgDevList.Count;
            if (iCount > aIndex)
            {
                rtDev = aProg->prgDevList.items[aIndex];
            };
        };
    };
  return(rtDev);
};
// KeyOf Functions for Lists
void *KeyOfDevList(void *aItem)
{ pDevEnt vDevEnt = (pDevEnt *)aItem;

  return(&vDevEnt->dveName);
};
