/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
#ifndef __progty__
#define __progty__
#include "libenv.h"
#include "prgdev.h" // Device structure

// Macros
#define INITPrg(aProg) \
    InitPrg(&aProg)
#define DONEPrg(aProg)  \
    DonePrg(&aProg)
//*****************************************************
typedef struct _tProg1532 {
  tList prgDevList;  // List of Devices

  // Added by Frank Phillips @ Xilinx on
  // May_10_2001
  // Added progMode to indicate concurent/sequential modes
  // 0 -- no mode specified, warning message and defaults sequential
  // 1 -- concurrent mode, 2 -- Seqential
  // 
  long progMode; 
} tProg1532, *pProg1532;

// whole structure
// for pProg1532 objects
pProg1532 NewPrg(void);
int FreePrg(pProg1532 aProg);
// for tProg1532 objects
void InitPrg(pProg1532 aProg);
int  DonePrg(pProg1532 aProg);

// Functions for Last Device in DeviceList

int AddDevice(pProg1532 aProg,PSTRING aDevName);            // Adding Device to List

void SetDevBsdlName(pProg1532 aProg, PSTRING aName);
void SetDevDFInpName(pProg1532 aProg,PSTRING aName);
void SetDevDFOutName(pProg1532 aProg, PSTRING aName);
void SetDevActionName(pProg1532 aProg, PSTRING aName);
void SetDevDataName(pProg1532 aProg, PSTRING aName);
void SetDevIrLength(pProg1532 aProg, int aIrLength);

// Get the Last Device
pDevEnt GetLastDevice(pProg1532 aProg);
int GetDeviceCount(pProg1532 aProg);
pDevEnt GetDeviceAtIndex(pProg1532 aProg, int aIndex);
// KeyOf Functions for List
void *KeyOfDevList(void *aItem);

#endif
