/*****************************************************************************
/* J Drive (tm) Engine
/* Copyright 2000, Xilinx, Inc.
/* The use, reproduction, and distribution of this code is subject
/* to the J Drive license requirements and restrictions.
*****************************************************************************/
/***** WIN32 ******************************************************************/
#ifdef SYSWin32

#include "sysopenv.h"

/* -------------------------------------------------------------------------- */
char ReadChar(FILE *aFile, int *aEof)
{
    int i;

    *aEof = 0;
    while (1)
    {
        i = fgetc(aFile);

        if (i == EOF)   // end of file
        {
            *aEof = 1;
            return (char)i;
        }
        if ((i >= 20) && (i <= 127)) // signs
        {
            return (char)i;
        }
        if (i == 0x09) // tab
            return (char)i;

        if (i == 0x0A)  // line break
            return '\n';
    }
}

/* -------------------------------------------------------------------------- */
int SetFilePos(FILE *aFile, long aPos)
{
    int i;

  fseek(aFile, 0, 0);

    while (aPos)
    {
        i = fgetc(aFile);

    if (i == EOF)
            return 1;

        if ((i >= 20) && (i <= 127))
            aPos--;

        if (i == 0x09) // tab
            aPos--;

        if (i == 0x0A)
            aPos--;
    }
    return 0;
}

#endif
/***** end SYSWin32 ***********************************************************/
