//--------------------------------------------------------------------
// TUCN, Computer Science Department
// Input/Output Systems and Peripheral Devices
//--------------------------------------------------------------------
// http://users.utcluj.ro/~baruch/en/pages/teaching/inputoutput-systems/laboratory.php
//--------------------------------------------------------------------
// File:		Menu-e.cpp
// Date:		10.08.2005
// Modified:	25.02.2009
//--------------------------------------------------------------------
// Template file for a Windows application window
//--------------------------------------------------------------------
// - Menus:		File -> Open
//				File -> Close
//				File -> Exit
//				Operations -> Operation 0 (no parameters)
//				Operations -> Operation 1 (no parameters)
//				Operations -> Operation 2 (no parameters)
//				Operations -> Operation 3 (no parameters)
//				Help -> About
//--------------------------------------------------------------------
// - Win32 API functions used:
//   CloseHandle, CreateFile, CreateFont, CreateWindowEx, DefWindowProc, 
//   DestroyWindow, DialogBox, DispatchMessage, EndDialog, GetDC, 
//   GetDeviceCaps, GetDlgItem, GetFileSize, GetMessage, GetModuleHandle,
//   GetOpenFileName, GetStockObject, GetSysColor, GetSystemMetrics, 
//   GlobalAlloc, GlobalFree, LoadImage, MessageBox, MulDiv, 
//   PostQuitMessage, PostMessage, ReadFile, RegisterClassEx, ReleaseDC,
//   SelectObject, SendMessage, SetBkColor, SetWindowText, ShowWindow, 
//   TranslateMessage, UpdateWindow, WndProc, ZeroMemory 
//--------------------------------------------------------------------
// - Operating system: Microsoft Windows 2000/XP
// - Compiler: Microsoft Visual Studio 2008
//--------------------------------------------------------------------

#include <windows.h>
#include "resource.h"

#define WIN32_LEAN_AND_MEAN		// optional: no MFC
//#define UNICODE				// optional: for Windows 2000/XP

//--------------------------------------------------------------------
// To be completed: Declarations of external functions
//
//--------------------------------------------------------------------

// Declarations of functions used
LRESULT CALLBACK WndProc (HWND hWnd, UINT uMes,
						  WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutDlgProc (HWND hWnd, UINT uMes,
						  WPARAM wParam, LPARAM lParam);
int ExecFileOpen (HWND hWnd);
HDC InitTextOut (HWND hWnd);

//--------------------------------------------------------------------
// Function ExecFileOpen
//--------------------------------------------------------------------
// 
// Function:	- Performs the dialog for selecting the file to open
//				- Opens the file
//				- Reads the file into a buffer
//				- Displays the file contents in an editing window
//
// Parameters:	hWnd - Handle to the application window
//
// Returns:		0 - The file has been opened and read successfully
//				1 - The dialog for open has been abandoned
//				2 - File open error
//				3 - Memory allocation error
//				4 - File read error
//
//--------------------------------------------------------------------

int ExecFileOpen (HWND hWnd)
{
	HANDLE hFile;				// handle to file
	OPENFILENAME ofn;			// structure for calling the dialog
								// function GetOpenFileName
	char szFileName [MAX_PATH+1] = "";
								// buffer for the file path and name
	DWORD dwFileSize;			// file size
	LPSTR pszBuffer;			// pointer to buffer for the file
	DWORD dwRead;				// number of bytes read
	HWND hDisplay;				// handle to display window
	HGDIOBJ hfFont;

	ZeroMemory (&ofn, sizeof (ofn));
	ofn.lStructSize = sizeof (OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFilter = "Text Files (*.txt)\0*.txt\0All Files (*.*)\0*.*\0";
	ofn.lpstrFile = szFileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrInitialDir = "D:\\Laborator\\SIE\\";
	ofn.Flags = OFN_HIDEREADONLY;
	ofn.lpstrDefExt = "txt";

	if (GetOpenFileName (&ofn) == 0)
		return 1;				// the dialog for file selection
								// has been abandoned
	hFile = CreateFile (szFileName, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_ALWAYS, 0, NULL);
	if (hFile == INVALID_HANDLE_VALUE) {
		MessageBox (hWnd, "File open error",
					"IOS Application", MB_OK | MB_ICONERROR);
		return 2;				// file open error
	}
	dwFileSize = GetFileSize (hFile, NULL);
	pszBuffer = (LPSTR) GlobalAlloc (GPTR, dwFileSize + 1);
								// allocate memory for the buffer
	if (pszBuffer == NULL)
		return 3;				// memory allocation error
	if (!ReadFile (hFile, pszBuffer, dwFileSize, &dwRead, NULL)) {
		MessageBox (hWnd, "File read error",
					"IOS Application", MB_OK | MB_ICONERROR);
		return 4;				// file read error
	}
	pszBuffer [dwFileSize] = 0;	// append a byte of 0 to the end

	hDisplay = CreateWindowEx (	// create the display window
		WS_EX_CLIENTEDGE,
		"EDIT",					// name of system class Edit
		"TextFile",				// name of window
		WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL |
		ES_MULTILINE | ES_AUTOVSCROLL,
		0,						// horizontal position
		0,						// vertical position
		GetSystemMetrics (SM_CXSCREEN)/2 - 10,
		GetSystemMetrics (SM_CYSCREEN)/2 - 50,
		hWnd,					// handle to parent window
		(HMENU) IDC_DISPLAY,	// identifier of display window
		GetModuleHandle (NULL),	// handle to module instance
		NULL);
	if (hDisplay == NULL)
		MessageBox (hWnd, "Error creating the display window",
					"Error", MB_OK | MB_ICONERROR);
	hfFont = GetStockObject (DEFAULT_GUI_FONT);
	SendMessage (hDisplay, WM_SETFONT, (WPARAM) hfFont,
		(LPARAM) FALSE);		// set the font
	SetWindowText (hDisplay, pszBuffer);
								// display the text
	GlobalFree (pszBuffer);		// release the memory
	CloseHandle (hFile);		// close the file
	return 0;
}

//--------------------------------------------------------------------
// Function InitTextOut
//--------------------------------------------------------------------
//
// Function:	- Determines the context of the display device
//				- Sets the type of characters to the default type
//				  used for menus and dialog boxes (MS Sans Serif)
//				- Sets the size of characters to 9 points
//				- Sets the background color to COLOR_BTNFACE
//
// Parameters:	hWnd - Handle to the application window
//
// Returns:		Handle to the context of the display device
//
//--------------------------------------------------------------------

HDC InitTextOut (HWND hWnd)
{
	HDC hDc;					// handle to device context
	HGDIOBJ hfFont;
	int lfSize;
	DWORD syscol;

	hDc = GetDC (hWnd);			// determine the device context
	lfSize = -MulDiv (9, GetDeviceCaps (hDc, LOGPIXELSY), 72);
								// determine the size in logical units
	hfFont = CreateFont (lfSize, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			"MS Sans Serif");	// create a logical font
	if (hfFont == NULL)
		hfFont = GetStockObject (DEFAULT_GUI_FONT);
	SelectObject (hDc, hfFont);	// set the new font
	syscol = GetSysColor (COLOR_BTNFACE);
								// determine the RGB value of the system color
	SetBkColor (hDc, syscol);	// set the background color
//	SetBkMode (hDc, TRANSPARENT);
	return hDc;
}

//--------------------------------------------------------------------
// Function WinMain
//--------------------------------------------------------------------

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
					LPSTR lpCmdLine, int nCmdShow)
{
	WNDCLASSEX Wnd;				// structure for the window class
	HWND hWnd;					// handle to window
	MSG Msg;					// structure for the messages
	HICON hIcon;
	HICON hIconSm;
	HCURSOR hCursor;
	const char szClassName [] = "SieWindowClass";

// Initialize the icons and window cursor
	hIcon = (HICON) LoadImage (NULL, "sie.ico", IMAGE_ICON, 
							   32, 32, LR_LOADFROMFILE);
	hIconSm = (HICON) LoadImage (NULL, "sie.ico", IMAGE_ICON, 
							   16, 16, LR_LOADFROMFILE);
	hCursor = (HCURSOR) LoadImage (NULL, IDC_ARROW, IMAGE_CURSOR, 
								   0, 0, LR_SHARED);

// Initialize the WNDCLASSEX structure
	Wnd.cbSize			= sizeof (WNDCLASSEX);	// size of the structure in bytes
	Wnd.style			= CS_HREDRAW | CS_VREDRAW;	// class style
	Wnd.lpfnWndProc		= (WNDPROC) WndProc;	// pointer to window function
	Wnd.cbClsExtra		= 0;
	Wnd.cbWndExtra		= 0;
	Wnd.hInstance		= hInstance;			// handle to application instance
	Wnd.hIcon			= hIcon;
	Wnd.hCursor			= hCursor;
	Wnd.hbrBackground	= (HBRUSH) (COLOR_BTNFACE+1);
	Wnd.lpszMenuName	= MAKEINTRESOURCE (IDR_SIEMENU1);
												// pointer to menu name
	Wnd.lpszClassName	= szClassName;			// pointer to class name
	Wnd.hIconSm			= hIconSm;

// Register the window class
	if (!RegisterClassEx (&Wnd)) {
		MessageBox (NULL, "Class registration error",
					"Error!", MB_OK | MB_ICONERROR);
		return 0;
	}

// Create the application window
	hWnd = CreateWindowEx (
		WS_EX_CLIENTEDGE,						// extended style
		szClassName,							// pointer to class name
		"IOS Application",						// window title
		WS_OVERLAPPEDWINDOW,					// window style
		GetSystemMetrics (SM_CXSCREEN)/4,		// horizontal position
		GetSystemMetrics (SM_CYSCREEN)/4,		// vertical position
		GetSystemMetrics (SM_CXSCREEN)/2,		// window width
		GetSystemMetrics (SM_CYSCREEN)/2,		// window height
		NULL,									// handle to parent window
		NULL,									// handle to window menu
		hInstance,								// handle to application instance
		NULL);									// pointer to a value sent to
												// the window
	if (hWnd == NULL) {
		MessageBox (NULL, "Error creating the application window",
					"Error", MB_OK | MB_ICONERROR);
		return 0;
	}

// Display the window
	ShowWindow (hWnd, nCmdShow); 
	UpdateWindow (hWnd);

// Message loop
	while (GetMessage (&Msg, NULL, 0, 0) > 0) {
		TranslateMessage (&Msg);
		DispatchMessage (&Msg);
	}
	return Msg.wParam;
}

//--------------------------------------------------------------------
// About dialog function
//--------------------------------------------------------------------

BOOL CALLBACK AboutDlgProc (HWND hWnd, UINT uMes,
						    WPARAM wParam, LPARAM lParam)
{
	switch (uMes) {
	case WM_INITDIALOG:
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD (wParam)) {
		case IDOK:
			EndDialog (hWnd, IDOK);
			return TRUE;
		case IDCANCEL:
			EndDialog (hWnd, IDCANCEL);
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//--------------------------------------------------------------------
// Window function
//--------------------------------------------------------------------

LRESULT CALLBACK WndProc (HWND hWnd, UINT uMes, WPARAM wParam, LPARAM lParam)
{
	HDC hDc;
	HWND hDisplay;
	switch (uMes) {
	case WM_COMMAND:
		switch (LOWORD (wParam)) {
		case ID_FILE_EXIT:
			PostMessage (hWnd, WM_CLOSE, 0, 0);
			break;
		case ID_FILE_OPEN:
			ExecFileOpen (hWnd);
			break;
		case ID_FILE_CLOSE:
			hDisplay = GetDlgItem (hWnd, IDC_DISPLAY);
			DestroyWindow (hDisplay);
			break;
		case ID_HELP_ABOUT:
			DialogBox (GetModuleHandle (NULL),
				MAKEINTRESOURCE (IDD_ABOUT), hWnd, AboutDlgProc);
			break;
		case ID_OPER_OP0:
			hDc = InitTextOut (hWnd);
//--------------------------------------------------------------------
//			To be completed: Call to Function 0
			MessageBox (hWnd, "No operation to be performed!",
						"IOS Application", MB_OK | MB_ICONINFORMATION);
//--------------------------------------------------------------------
			ReleaseDC (hWnd, hDc);
			break;
		case ID_OPER_OP1:
			hDc = InitTextOut (hWnd);
//--------------------------------------------------------------------
//			To be completed: Call to Function 1
			MessageBox (hWnd, "No operation to be performed!",
						"IOS Application", MB_OK | MB_ICONINFORMATION);
//--------------------------------------------------------------------
			ReleaseDC (hWnd, hDc);
			break;
		case ID_OPER_OP2:
			hDc = InitTextOut (hWnd);
//--------------------------------------------------------------------
//			To be completed: Call to Function 2
			MessageBox (hWnd, "No operation to be performed!",
						"IOS Application", MB_OK | MB_ICONINFORMATION);
//--------------------------------------------------------------------
			ReleaseDC (hWnd, hDc);
			break;
		case ID_OPER_OP3:
			hDc = InitTextOut (hWnd);
//--------------------------------------------------------------------
//			To be completed: Call to Function 3
			MessageBox (hWnd, "No operation to be performed!",
						"IOS Application", MB_OK | MB_ICONINFORMATION);
//--------------------------------------------------------------------
			ReleaseDC (hWnd, hDc);
			break;
		}
		return 0;
	case WM_CLOSE:
		DestroyWindow (hWnd);
		return 0;
	case WM_DESTROY:
		PostQuitMessage (0);
		return 0;
	default:
		return DefWindowProc (hWnd, uMes, wParam, lParam);
	}
}
